/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.aspectj.asm.IHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.context.PinpointingMessageHandler;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.IHasSourceLocation;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MissingResolvedTypeWithKnownSignature;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;

public abstract class World
implements Dump.INode {
    private IMessageHandler messageHandler = IMessageHandler.SYSTEM_ERR;
    private ICrossReferenceHandler xrefHandler = null;
    private TypeVariableDeclaringElement typeVariableLookupScope;
    protected TypeMap typeMap = new TypeMap(this);
    public static boolean createInjarHierarchy = true;
    private AspectPrecedenceCalculator precedenceCalculator;
    private CrosscuttingMembersSet crosscuttingMembersSet = new CrosscuttingMembersSet(this);
    private IHierarchy model = null;
    private Lint lint = new Lint(this);
    private boolean XnoInline;
    private boolean XlazyTjp;
    private boolean XhasMember = false;
    private boolean Xpinpoint = false;
    private boolean behaveInJava5Way = false;
    private boolean incrementalCompileCouldFollow = false;
    private String targetAspectjRuntimeLevel = "1.5";
    private boolean optionalJoinpoint_ArrayConstruction = false;
    private boolean optionalJoinpoint_Synchronization = false;
    private boolean addSerialVerUID = false;
    private Properties extraConfiguration = null;
    private boolean checkedAdvancedConfiguration = false;
    private boolean synchronizationPointcutsInUse = false;
    private boolean fastDelegateSupportEnabled = isASMAround;
    private boolean runMinimalMemory = false;
    private boolean shouldPipelineCompilation = true;
    protected boolean bcelRepositoryCaching = "true".equalsIgnoreCase("true");
    private boolean completeBinaryTypes = false;
    public boolean forDEBUG_structuralChangesCode = false;
    public boolean forDEBUG_bridgingCode = false;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$World == null ? (class$org$aspectj$weaver$World = World.class$("org.aspectj.weaver.World")) : class$org$aspectj$weaver$World);
    protected static boolean isASMAround = false;
    private long errorThreshold;
    private long warningThreshold;
    private List dumpState_cantFindTypeExceptions = null;
    private ResolvedType currentlyResolvingBaseType;
    public static final String xsetCAPTURE_ALL_CONTEXT = "captureAllContext";
    public static final String xsetACTIVATE_LIGHTWEIGHT_DELEGATES = "activateLightweightDelegates";
    public static final String xsetRUN_MINIMAL_MEMORY = "runMinimalMemory";
    public static final String xsetDEBUG_STRUCTURAL_CHANGES_CODE = "debugStructuralChangesCode";
    public static final String xsetDEBUG_BRIDGING = "debugBridging";
    public static final String xsetBCEL_REPOSITORY_CACHING = "bcelRepositoryCaching";
    public static final String xsetPIPELINE_COMPILATION = "pipelineCompilation";
    public static final String xsetPIPELINE_COMPILATION_DEFAULT = "true";
    public static final String xsetCOMPLETE_BINARY_TYPES = "completeBinaryTypes";
    public static final String xsetCOMPLETE_BINARY_TYPES_DEFAULT = "false";
    public static final String xsetBCEL_REPOSITORY_CACHING_DEFAULT = "true";
    private Map workInProgress1 = new HashMap();
    static /* synthetic */ Class class$org$aspectj$weaver$World;
    static /* synthetic */ Class class$org$aspectj$weaver$World$TypeMap;

    protected World() {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", this);
        }
        Dump.registerNode(this.getClass(), this);
        this.typeMap.put("B", ResolvedType.BYTE);
        this.typeMap.put("S", ResolvedType.SHORT);
        this.typeMap.put("I", ResolvedType.INT);
        this.typeMap.put("J", ResolvedType.LONG);
        this.typeMap.put("F", ResolvedType.FLOAT);
        this.typeMap.put("D", ResolvedType.DOUBLE);
        this.typeMap.put("C", ResolvedType.CHAR);
        this.typeMap.put("Z", ResolvedType.BOOLEAN);
        this.typeMap.put("V", ResolvedType.VOID);
        this.precedenceCalculator = new AspectPrecedenceCalculator(this);
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public void accept(Dump.IVisitor visitor) {
        visitor.visitObject("Shadow mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getShadowMungers());
        visitor.visitObject("Type mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getTypeMungers());
        visitor.visitObject("Late Type mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getLateTypeMungers());
        if (this.dumpState_cantFindTypeExceptions != null) {
            visitor.visitObject("Cant find type problems:");
            visitor.visitList(this.dumpState_cantFindTypeExceptions);
            this.dumpState_cantFindTypeExceptions = null;
        }
    }

    public ResolvedType resolve(UnresolvedType ty) {
        return this.resolve(ty, false);
    }

    public ResolvedType resolve(UnresolvedType ty, ISourceLocation isl) {
        ResolvedType ret = this.resolve(ty, true);
        if (ResolvedType.isMissing(ty)) {
            this.getLint().cantFindType.signal(WeaverMessages.format("cantFindType", ty.getName()), isl);
        }
        return ret;
    }

    public ResolvedType[] resolve(UnresolvedType[] types) {
        if (types == null) {
            return new ResolvedType[0];
        }
        ResolvedType[] ret = new ResolvedType[types.length];
        for (int i = 0; i < types.length; ++i) {
            ret[i] = this.resolve(types[i]);
        }
        return ret;
    }

    public ResolvedType resolve(UnresolvedType ty, boolean allowMissing) {
        if (ty instanceof ResolvedType) {
            ResolvedType rty = (ResolvedType)ty;
            rty = this.resolve(rty);
            return rty;
        }
        if (ty.isTypeVariableReference()) {
            return ty.resolve(this);
        }
        String signature = ty.getSignature();
        ResolvedType ret = this.typeMap.get(signature);
        if (ret != null) {
            ret.world = this;
            return ret;
        }
        if (signature.equals("?") || signature.equals("*")) {
            BoundedReferenceType something = new BoundedReferenceType("?", "Ljava/lang/Object", this);
            this.typeMap.put("?", something);
            return something;
        }
        if (ty.isArray()) {
            ResolvedType componentType = this.resolve(ty.getComponentType(), allowMissing);
            ret = new ResolvedType.Array(signature, "[" + componentType.getErasureSignature(), this, componentType);
        } else {
            ret = this.resolveToReferenceType(ty, allowMissing);
            if (!allowMissing && ret.isMissing()) {
                ret = this.handleRequiredMissingTypeDuringResolution(ty);
            }
            if (this.completeBinaryTypes) {
                this.completeBinaryType(ret);
            }
        }
        if (this.typeMap.get(signature) == null && !ret.isMissing()) {
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    protected void completeBinaryType(ResolvedType ret) {
    }

    public boolean isLocallyDefined(String classname) {
        return false;
    }

    private ResolvedType handleRequiredMissingTypeDuringResolution(UnresolvedType ty) {
        if (this.dumpState_cantFindTypeExceptions == null) {
            this.dumpState_cantFindTypeExceptions = new ArrayList();
        }
        this.dumpState_cantFindTypeExceptions.add(new RuntimeException("Can't find type " + ty.getName()));
        return new MissingResolvedTypeWithKnownSignature(ty.getSignature(), this);
    }

    public ResolvedType resolve(ResolvedType ty) {
        if (ty.isTypeVariableReference()) {
            return ty;
        }
        ResolvedType resolved = this.typeMap.get(ty.getSignature());
        if (resolved == null) {
            this.typeMap.put(ty.getSignature(), ty);
            resolved = ty;
        }
        resolved.world = this;
        return resolved;
    }

    public ResolvedType resolve(String name) {
        ResolvedType ret = this.resolve(UnresolvedType.forName(name));
        return ret;
    }

    public ResolvedType resolve(String name, boolean allowMissing) {
        return this.resolve(UnresolvedType.forName(name), allowMissing);
    }

    private final ResolvedType resolveToReferenceType(UnresolvedType ty, boolean allowMissing) {
        ReferenceTypeDelegate delegate;
        if (ty.isParameterizedType()) {
            ResolvedType rt = this.resolveGenericTypeFor(ty, allowMissing);
            if (rt.isMissing()) {
                return rt;
            }
            ReferenceType genericType = (ReferenceType)rt;
            this.currentlyResolvingBaseType = genericType;
            ReferenceType parameterizedType = TypeFactory.createParameterizedType(genericType, ty.typeParameters, this);
            this.currentlyResolvingBaseType = null;
            return parameterizedType;
        }
        if (ty.isGenericType()) {
            ReferenceType genericType = (ReferenceType)this.resolveGenericTypeFor(ty, false);
            return genericType;
        }
        if (ty.isGenericWildcard()) {
            return this.resolveGenericWildcardFor(ty);
        }
        String erasedSignature = ty.getErasureSignature();
        ReferenceType simpleOrRawType = new ReferenceType(erasedSignature, this);
        if (ty.needsModifiableDelegate()) {
            simpleOrRawType.setNeedsModifiableDelegate(true);
        }
        if ((delegate = this.resolveDelegate(simpleOrRawType)) == null) {
            return new MissingResolvedTypeWithKnownSignature(ty.getSignature(), erasedSignature, this);
        }
        if (delegate.isGeneric() && this.behaveInJava5Way) {
            simpleOrRawType.typeKind = UnresolvedType.TypeKind.RAW;
            ReferenceType genericType = this.makeGenericTypeFrom(delegate, simpleOrRawType);
            simpleOrRawType.setDelegate(delegate);
            genericType.setDelegate(delegate);
            simpleOrRawType.setGenericType(genericType);
            return simpleOrRawType;
        }
        simpleOrRawType.setDelegate(delegate);
        return simpleOrRawType;
    }

    public ResolvedType resolveGenericTypeFor(UnresolvedType anUnresolvedType, boolean allowMissing) {
        String rawSignature = anUnresolvedType.getRawType().getSignature();
        ResolvedType rawType = this.typeMap.get(rawSignature);
        if (rawType == null) {
            rawType = this.resolve(UnresolvedType.forSignature(rawSignature), allowMissing);
            this.typeMap.put(rawSignature, rawType);
        }
        if (rawType.isMissing()) {
            return rawType;
        }
        ResolvedType genericType = rawType.getGenericType();
        if (rawType.isSimpleType() && (anUnresolvedType.typeParameters == null || anUnresolvedType.typeParameters.length == 0)) {
            rawType.world = this;
            return rawType;
        }
        if (genericType != null) {
            genericType.world = this;
            return genericType;
        }
        ReferenceTypeDelegate delegate = this.resolveDelegate((ReferenceType)rawType);
        ReferenceType genericRefType = this.makeGenericTypeFrom(delegate, (ReferenceType)rawType);
        ((ReferenceType)rawType).setGenericType(genericRefType);
        genericRefType.setDelegate(delegate);
        ((ReferenceType)rawType).setDelegate(delegate);
        return genericRefType;
    }

    private ReferenceType makeGenericTypeFrom(ReferenceTypeDelegate delegate, ReferenceType rawType) {
        String genericSig = delegate.getDeclaredGenericSignature();
        if (genericSig != null) {
            return new ReferenceType(UnresolvedType.forGenericTypeSignature(rawType.getSignature(), delegate.getDeclaredGenericSignature()), this);
        }
        return new ReferenceType(UnresolvedType.forGenericTypeVariables(rawType.getSignature(), delegate.getTypeVariables()), this);
    }

    private ReferenceType resolveGenericWildcardFor(UnresolvedType aType) {
        BoundedReferenceType ret = null;
        if (aType.isExtends()) {
            ReferenceType upperBound = (ReferenceType)this.resolve(aType.getUpperBound());
            ret = new BoundedReferenceType(upperBound, true, this);
        } else if (aType.isSuper()) {
            ReferenceType lowerBound = (ReferenceType)this.resolve(aType.getLowerBound());
            ret = new BoundedReferenceType(lowerBound, false, this);
        }
        return ret;
    }

    protected abstract ReferenceTypeDelegate resolveDelegate(ReferenceType var1);

    public ResolvedType getCoreType(UnresolvedType tx) {
        ResolvedType coreTy = this.resolve(tx, true);
        if (coreTy.isMissing()) {
            MessageUtil.error(this.messageHandler, WeaverMessages.format("cantFindCoreType", tx.getName()));
        }
        return coreTy;
    }

    public ReferenceType lookupOrCreateName(UnresolvedType ty) {
        String signature = ty.getSignature();
        ReferenceType ret = this.lookupBySignature(signature);
        if (ret == null) {
            ret = ReferenceType.fromTypeX(ty, this);
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    public ReferenceType lookupBySignature(String signature) {
        return (ReferenceType)this.typeMap.get(signature);
    }

    public ResolvedMember resolve(Member member) {
        ResolvedMember ret;
        ResolvedType declaring = member.getDeclaringType().resolve(this);
        if (declaring.isRawType()) {
            declaring = declaring.getGenericType();
        }
        if ((ret = member.getKind() == Member.FIELD ? declaring.lookupField(member) : declaring.lookupMethod(member)) != null) {
            return ret;
        }
        return declaring.lookupSyntheticMember(member);
    }

    public abstract Advice createAdviceMunger(AjAttribute.AdviceAttribute var1, Pointcut var2, Member var3);

    public final Advice createAdviceMunger(AdviceKind kind, Pointcut p, Member signature, int extraParameterFlags, IHasSourceLocation loc) {
        AjAttribute.AdviceAttribute attribute = new AjAttribute.AdviceAttribute(kind, p, extraParameterFlags, loc.getStart(), loc.getEnd(), loc.getSourceContext());
        return this.createAdviceMunger(attribute, p, signature);
    }

    public abstract ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember var1);

    public abstract ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember var1);

    public abstract ConcreteTypeMunger makePerClauseAspect(ResolvedType var1, PerClause.Kind var2);

    public abstract ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger var1, ResolvedType var2);

    public int compareByPrecedence(ResolvedType aspect1, ResolvedType aspect2) {
        return this.precedenceCalculator.compareByPrecedence(aspect1, aspect2);
    }

    public Integer getPrecedenceIfAny(ResolvedType aspect1, ResolvedType aspect2) {
        return this.precedenceCalculator.getPrecedenceIfAny(aspect1, aspect2);
    }

    public int compareByPrecedenceAndHierarchy(ResolvedType aspect1, ResolvedType aspect2) {
        return this.precedenceCalculator.compareByPrecedenceAndHierarchy(aspect1, aspect2);
    }

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(IMessageHandler messageHandler) {
        this.messageHandler = this.isInPinpointMode() ? new PinpointingMessageHandler(messageHandler) : messageHandler;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        if (loc1 != null) {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc1));
            if (loc2 != null) {
                this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
            }
        } else {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
        }
    }

    public boolean debug(String message) {
        return MessageUtil.debug(this.messageHandler, message);
    }

    public void setCrossReferenceHandler(ICrossReferenceHandler xrefHandler) {
        this.xrefHandler = xrefHandler;
    }

    public ICrossReferenceHandler getCrossReferenceHandler() {
        return this.xrefHandler;
    }

    public void setTypeVariableLookupScope(TypeVariableDeclaringElement scope) {
        this.typeVariableLookupScope = scope;
    }

    public TypeVariableDeclaringElement getTypeVariableLookupScope() {
        return this.typeVariableLookupScope;
    }

    public List getDeclareParents() {
        return this.crosscuttingMembersSet.getDeclareParents();
    }

    public List getDeclareAnnotationOnTypes() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnTypes();
    }

    public List getDeclareAnnotationOnFields() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnFields();
    }

    public List getDeclareAnnotationOnMethods() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnMethods();
    }

    public List getDeclareSoft() {
        return this.crosscuttingMembersSet.getDeclareSofts();
    }

    public CrosscuttingMembersSet getCrosscuttingMembersSet() {
        return this.crosscuttingMembersSet;
    }

    public IHierarchy getModel() {
        return this.model;
    }

    public void setModel(IHierarchy model) {
        this.model = model;
    }

    public Lint getLint() {
        return this.lint;
    }

    public void setLint(Lint lint) {
        this.lint = lint;
    }

    public boolean isXnoInline() {
        return this.XnoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.XnoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.XlazyTjp;
    }

    public void setXlazyTjp(boolean b) {
        this.XlazyTjp = b;
    }

    public boolean isHasMemberSupportEnabled() {
        return this.XhasMember;
    }

    public void setXHasMemberSupportEnabled(boolean b) {
        this.XhasMember = b;
    }

    public boolean isInPinpointMode() {
        return this.Xpinpoint;
    }

    public void setPinpointMode(boolean b) {
        this.Xpinpoint = b;
    }

    public void setBehaveInJava5Way(boolean b) {
        this.behaveInJava5Way = b;
    }

    public void setErrorAndWarningThreshold(long errorThreshold, long warningThreshold) {
        this.errorThreshold = errorThreshold;
        this.warningThreshold = warningThreshold;
    }

    public boolean isIgnoringUnusedDeclaredThrownException() {
        return (this.errorThreshold & 0x800000L) == 0L && (this.warningThreshold & 0x800000L) == 0L;
    }

    public void performExtraConfiguration(String config) {
        int pos2;
        if (config == null) {
            return;
        }
        this.extraConfiguration = new Properties();
        int pos = -1;
        while ((pos = config.indexOf(",")) != -1) {
            String nvpair = config.substring(0, pos);
            int pos22 = nvpair.indexOf("=");
            if (pos22 != -1) {
                String n = nvpair.substring(0, pos22);
                String v = nvpair.substring(pos22 + 1);
                this.extraConfiguration.setProperty(n, v);
            }
            config = config.substring(pos + 1);
        }
        if (config.length() > 0 && (pos2 = config.indexOf("=")) != -1) {
            String n = config.substring(0, pos2);
            String v = config.substring(pos2 + 1);
            this.extraConfiguration.setProperty(n, v);
        }
        this.ensureAdvancedConfigurationProcessed();
    }

    public Properties getExtraConfiguration() {
        return this.extraConfiguration;
    }

    public boolean isInJava5Mode() {
        return this.behaveInJava5Way;
    }

    public void setTargetAspectjRuntimeLevel(String s) {
        this.targetAspectjRuntimeLevel = s;
    }

    public void setOptionalJoinpoints(String jps) {
        if (jps == null) {
            return;
        }
        if (jps.indexOf("arrayconstruction") != -1) {
            this.optionalJoinpoint_ArrayConstruction = true;
        }
        if (jps.indexOf("synchronization") != -1) {
            this.optionalJoinpoint_Synchronization = true;
        }
    }

    public boolean isJoinpointArrayConstructionEnabled() {
        return this.optionalJoinpoint_ArrayConstruction;
    }

    public boolean isJoinpointSynchronizationEnabled() {
        return this.optionalJoinpoint_Synchronization;
    }

    public String getTargetAspectjRuntimeLevel() {
        return this.targetAspectjRuntimeLevel;
    }

    public boolean isTargettingAspectJRuntime12() {
        boolean b = false;
        b = !this.isInJava5Mode() ? true : this.getTargetAspectjRuntimeLevel().equals("1.2");
        return b;
    }

    protected boolean isExpendable(ResolvedType type) {
        return !type.equals(UnresolvedType.OBJECT) && type != null && !type.isExposedToWeaver() && !type.isPrimitiveType();
    }

    public void validateType(UnresolvedType type) {
    }

    public TypeVariable[] getTypeVariablesCurrentlyBeingProcessed(Class baseClass) {
        return (TypeVariable[])this.workInProgress1.get(baseClass);
    }

    public void recordTypeVariablesCurrentlyBeingProcessed(Class baseClass, TypeVariable[] typeVariables) {
        this.workInProgress1.put(baseClass, typeVariables);
    }

    public void forgetTypeVariablesCurrentlyBeingProcessed(Class baseClass) {
        this.workInProgress1.remove(baseClass);
    }

    public void setAddSerialVerUID(boolean b) {
        this.addSerialVerUID = b;
    }

    public boolean isAddSerialVerUID() {
        return this.addSerialVerUID;
    }

    public void flush() {
        this.typeMap.expendableMap.clear();
    }

    public void ensureAdvancedConfigurationProcessed() {
        if (!this.checkedAdvancedConfiguration) {
            Properties p = this.getExtraConfiguration();
            if (p != null) {
                String s;
                if (isASMAround) {
                    s = p.getProperty(xsetACTIVATE_LIGHTWEIGHT_DELEGATES, "true");
                    this.fastDelegateSupportEnabled = s.equalsIgnoreCase("true");
                    if (!this.fastDelegateSupportEnabled) {
                        this.getMessageHandler().handleMessage(MessageUtil.info("[activateLightweightDelegates=false] Disabling optimization to use lightweight delegates for non-woven types"));
                    }
                }
                s = p.getProperty(xsetBCEL_REPOSITORY_CACHING, "true");
                this.bcelRepositoryCaching = s.equalsIgnoreCase("true");
                if (!this.bcelRepositoryCaching) {
                    this.getMessageHandler().handleMessage(MessageUtil.info("[bcelRepositoryCaching=false] AspectJ will not use a bcel cache for class information"));
                }
                s = p.getProperty(xsetPIPELINE_COMPILATION, "true");
                this.shouldPipelineCompilation = s.equalsIgnoreCase("true");
                s = p.getProperty(xsetCOMPLETE_BINARY_TYPES, xsetCOMPLETE_BINARY_TYPES_DEFAULT);
                this.completeBinaryTypes = s.equalsIgnoreCase("true");
                if (this.completeBinaryTypes) {
                    this.getMessageHandler().handleMessage(MessageUtil.info("[completeBinaryTypes=true] Completion of binary types activated"));
                }
                s = p.getProperty(xsetRUN_MINIMAL_MEMORY, xsetCOMPLETE_BINARY_TYPES_DEFAULT);
                this.runMinimalMemory = s.equalsIgnoreCase("true");
                s = p.getProperty(xsetDEBUG_STRUCTURAL_CHANGES_CODE, xsetCOMPLETE_BINARY_TYPES_DEFAULT);
                this.forDEBUG_structuralChangesCode = s.equalsIgnoreCase("true");
                s = p.getProperty(xsetDEBUG_BRIDGING, xsetCOMPLETE_BINARY_TYPES_DEFAULT);
                this.forDEBUG_bridgingCode = s.equalsIgnoreCase("true");
            }
            this.checkedAdvancedConfiguration = true;
        }
    }

    public boolean isRunMinimalMemory() {
        this.ensureAdvancedConfigurationProcessed();
        return this.runMinimalMemory;
    }

    public boolean shouldPipelineCompilation() {
        this.ensureAdvancedConfigurationProcessed();
        return this.shouldPipelineCompilation;
    }

    public void setFastDelegateSupport(boolean b) {
        if (b && !isASMAround) {
            throw new BCException("Unable to activate fast delegate support, ASM classes cannot be found");
        }
        this.fastDelegateSupportEnabled = b;
    }

    public boolean isFastDelegateSupportEnabled() {
        return false;
    }

    public void setIncrementalCompileCouldFollow(boolean b) {
        this.incrementalCompileCouldFollow = b;
    }

    public boolean couldIncrementalCompileFollow() {
        return this.incrementalCompileCouldFollow;
    }

    public void setSynchronizationPointcutsInUse() {
        if (trace.isTraceEnabled()) {
            trace.enter("setSynchronizationPointcutsInUse", this);
        }
        this.synchronizationPointcutsInUse = true;
        if (trace.isTraceEnabled()) {
            trace.exit("setSynchronizationPointcutsInUse");
        }
    }

    public boolean areSynchronizationPointcutsInUse() {
        return this.synchronizationPointcutsInUse;
    }

    public boolean isASMAround() {
        return isASMAround;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AspectPrecedenceCalculator {
        private World world;
        private Map cachedResults;

        public AspectPrecedenceCalculator(World forSomeWorld) {
            this.world = forSomeWorld;
            this.cachedResults = new HashMap();
        }

        public int compareByPrecedence(ResolvedType firstAspect, ResolvedType secondAspect) {
            PrecedenceCacheKey key = new PrecedenceCacheKey(firstAspect, secondAspect);
            if (this.cachedResults.containsKey(key)) {
                return (Integer)this.cachedResults.get(key);
            }
            int order = 0;
            DeclarePrecedence orderer = null;
            Iterator i = this.world.getCrosscuttingMembersSet().getDeclareDominates().iterator();
            while (i.hasNext()) {
                DeclarePrecedence d = (DeclarePrecedence)i.next();
                int thisOrder = d.compare(firstAspect, secondAspect);
                if (thisOrder == 0) continue;
                if (orderer == null) {
                    orderer = d;
                }
                if (order != 0 && order != thisOrder) {
                    ISourceLocation[] isls = new ISourceLocation[]{orderer.getSourceLocation(), d.getSourceLocation()};
                    Message m = new Message("conflicting declare precedence orderings for aspects: " + firstAspect.getName() + " and " + secondAspect.getName(), null, true, isls);
                    this.world.getMessageHandler().handleMessage(m);
                    continue;
                }
                order = thisOrder;
            }
            this.cachedResults.put(key, new Integer(order));
            return order;
        }

        public Integer getPrecedenceIfAny(ResolvedType aspect1, ResolvedType aspect2) {
            return (Integer)this.cachedResults.get(new PrecedenceCacheKey(aspect1, aspect2));
        }

        public int compareByPrecedenceAndHierarchy(ResolvedType firstAspect, ResolvedType secondAspect) {
            if (firstAspect.equals(secondAspect)) {
                return 0;
            }
            int ret = this.compareByPrecedence(firstAspect, secondAspect);
            if (ret != 0) {
                return ret;
            }
            if (firstAspect.isAssignableFrom(secondAspect)) {
                return -1;
            }
            if (secondAspect.isAssignableFrom(firstAspect)) {
                return 1;
            }
            return 0;
        }

        private static class PrecedenceCacheKey {
            public ResolvedType aspect1;
            public ResolvedType aspect2;

            public PrecedenceCacheKey(ResolvedType a1, ResolvedType a2) {
                this.aspect1 = a1;
                this.aspect2 = a2;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof PrecedenceCacheKey)) {
                    return false;
                }
                PrecedenceCacheKey other = (PrecedenceCacheKey)obj;
                return this.aspect1 == other.aspect1 && this.aspect2 == other.aspect2;
            }

            public int hashCode() {
                return this.aspect1.hashCode() + this.aspect2.hashCode();
            }
        }
    }

    protected static class TypeMap {
        private static boolean debug = false;
        public static int DONT_USE_REFS = 0;
        public static int USE_WEAK_REFS = 1;
        public static int USE_SOFT_REFS;
        public static int policy;
        private Map tMap = new HashMap();
        private Map expendableMap = new WeakHashMap();
        private World w;
        private boolean memoryProfiling = false;
        private int maxExpendableMapSize = -1;
        private int collectedTypes = 0;
        private ReferenceQueue rq = new ReferenceQueue();
        private static Trace trace;

        TypeMap(World w) {
            if (trace.isTraceEnabled()) {
                trace.enter("<init>", (Object)this, w);
            }
            this.w = w;
            this.memoryProfiling = false;
            if (trace.isTraceEnabled()) {
                trace.exit("<init>");
            }
        }

        public ResolvedType put(String key, ResolvedType type) {
            if (type.isParameterizedType() && type.isParameterizedWithAMemberTypeVariable()) {
                if (debug) {
                    System.err.println("Not putting a parameterized type that utilises member declared type variables into the typemap: key=" + key + " type=" + type);
                }
                return type;
            }
            if (type.isTypeVariableReference()) {
                if (debug) {
                    System.err.println("Not putting a type variable reference type into the typemap: key=" + key + " type=" + type);
                }
                return type;
            }
            if (type instanceof BoundedReferenceType) {
                if (debug) {
                    System.err.println("Not putting a bounded reference type into the typemap: key=" + key + " type=" + type);
                }
                return type;
            }
            if (type instanceof MissingResolvedTypeWithKnownSignature) {
                if (debug) {
                    System.err.println("Not putting a missing type into the typemap: key=" + key + " type=" + type);
                }
                return type;
            }
            if (type instanceof ReferenceType && ((ReferenceType)type).getDelegate() == null && this.w.isExpendable(type)) {
                if (debug) {
                    System.err.println("Not putting expendable ref type with null delegate into typemap: key=" + key + " type=" + type);
                }
                return type;
            }
            if (this.w.isExpendable(type)) {
                if (policy == USE_WEAK_REFS) {
                    if (this.memoryProfiling) {
                        this.expendableMap.put(key, new WeakReference<ResolvedType>(type, this.rq));
                    } else {
                        this.expendableMap.put(key, new WeakReference<ResolvedType>(type));
                    }
                } else if (policy == USE_SOFT_REFS) {
                    if (this.memoryProfiling) {
                        this.expendableMap.put(key, new SoftReference<ResolvedType>(type, this.rq));
                    } else {
                        this.expendableMap.put(key, new SoftReference<ResolvedType>(type));
                    }
                } else {
                    this.expendableMap.put(key, type);
                }
                if (this.memoryProfiling && this.expendableMap.size() > this.maxExpendableMapSize) {
                    this.maxExpendableMapSize = this.expendableMap.size();
                }
                return type;
            }
            return this.tMap.put(key, type);
        }

        public void report() {
            if (!this.memoryProfiling) {
                return;
            }
            this.checkq();
            this.w.getMessageHandler().handleMessage(MessageUtil.info("MEMORY: world expendable type map reached maximum size of #" + this.maxExpendableMapSize + " entries"));
            this.w.getMessageHandler().handleMessage(MessageUtil.info("MEMORY: types collected through garbage collection #" + this.collectedTypes + " entries"));
        }

        public void checkq() {
            if (!this.memoryProfiling) {
                return;
            }
            while (this.rq.poll() != null) {
                ++this.collectedTypes;
            }
        }

        public ResolvedType get(String key) {
            this.checkq();
            ResolvedType ret = (ResolvedType)this.tMap.get(key);
            if (ret == null) {
                if (policy == USE_WEAK_REFS) {
                    WeakReference ref = (WeakReference)this.expendableMap.get(key);
                    if (ref != null) {
                        ret = (ResolvedType)ref.get();
                    }
                } else if (policy == USE_SOFT_REFS) {
                    SoftReference ref = (SoftReference)this.expendableMap.get(key);
                    if (ref != null) {
                        ret = (ResolvedType)ref.get();
                    }
                } else {
                    return (ResolvedType)this.expendableMap.get(key);
                }
            }
            return ret;
        }

        public ResolvedType remove(String key) {
            ResolvedType ret = (ResolvedType)this.tMap.remove(key);
            if (ret == null) {
                if (policy == USE_WEAK_REFS) {
                    WeakReference wref = (WeakReference)this.expendableMap.remove(key);
                    if (wref != null) {
                        ret = (ResolvedType)wref.get();
                    }
                } else if (policy == USE_SOFT_REFS) {
                    SoftReference wref = (SoftReference)this.expendableMap.remove(key);
                    if (wref != null) {
                        ret = (ResolvedType)wref.get();
                    }
                } else {
                    ret = (ResolvedType)this.expendableMap.remove(key);
                }
            }
            return ret;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("types:\n");
            sb.append(this.dumpthem(this.tMap));
            sb.append("expendables:\n");
            sb.append(this.dumpthem(this.expendableMap));
            return sb.toString();
        }

        private String dumpthem(Map m) {
            StringBuffer sb = new StringBuffer();
            int otherTypes = 0;
            int bcelDel = 0;
            int refDel = 0;
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object val = entry.getValue();
                if (val instanceof WeakReference) {
                    val = ((WeakReference)val).get();
                } else if (val instanceof SoftReference) {
                    val = ((SoftReference)val).get();
                }
                sb.append(entry.getKey() + "=" + val).append("\n");
                if (val instanceof ReferenceType) {
                    ReferenceType refType = (ReferenceType)val;
                    if (refType.getDelegate() instanceof BcelObjectType) {
                        ++bcelDel;
                        continue;
                    }
                    if (refType.getDelegate() instanceof ReflectionBasedReferenceTypeDelegate) {
                        ++refDel;
                        continue;
                    }
                    ++otherTypes;
                    continue;
                }
                ++otherTypes;
            }
            sb.append("# BCEL = " + bcelDel + ", # REF = " + refDel + ", # Other = " + otherTypes);
            return sb.toString();
        }

        public int totalSize() {
            return this.tMap.size() + this.expendableMap.size();
        }

        public int hardSize() {
            return this.tMap.size();
        }

        static {
            policy = USE_SOFT_REFS = 2;
            trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$World$TypeMap == null ? (class$org$aspectj$weaver$World$TypeMap = World.class$("org.aspectj.weaver.World$TypeMap")) : class$org$aspectj$weaver$World$TypeMap);
        }
    }
}

