/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.trace;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import jd.xml.util.XmlWriter;
import jd.xml.xpath.expr.Expression;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.template.Template;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.trace.Location;

public class Tracer {
    private XmlWriter out_;
    private Vector uris_ = new Vector();
    private Vector uriIds_ = new Vector();

    public void start() {
        try {
            this.out_ = new XmlWriter((OutputStream)System.out, "iso-8859-1", true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
        this.uris_.clear();
        this.out_.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
        this.startElementOpen("trace", null);
        this.startElementClose();
        this.out_.println();
        this.out_.increaseTab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            this.printUris();
            this.out_.decreaseTab();
            this.endElement("trace");
            this.out_.println();
            this.out_.close();
        }
        finally {
            this.out_ = null;
        }
    }

    public void expression(Location location, Expression expression, String string) {
        if (this.out_ != null) {
            this.startElementOpen("expr", location);
            this.startElementClose();
            this.out_.printText(string);
            this.endElement("expr");
            this.out_.println();
        }
    }

    public void pattern(Location location, Pattern pattern, String string) {
        if (this.out_ != null) {
            this.startElementOpen("pattern", location);
            this.startElementClose();
            this.out_.printText(string);
            this.endElement("pattern");
            this.out_.println();
        }
    }

    public void templateStarted(Location location, Template template, String string) {
        if (this.out_ != null) {
            this.startElementOpen("template", location);
            this.out_.printAttribute("name", string);
            this.startElementClose();
            this.out_.println();
            this.out_.increaseTab();
        }
    }

    public void templateEnded(Location location, Template template, String string) {
        if (this.out_ != null) {
            this.out_.decreaseTab();
            this.endElement("template");
            this.out_.println();
        }
    }

    public void templateRuleStarted(Location location, TemplateRule templateRule) {
        if (this.out_ != null) {
            this.startElementOpen("templateRule", location);
            this.startElementClose();
            this.out_.println();
            this.out_.increaseTab();
        }
    }

    public void templateRuleEnded(Location location, TemplateRule templateRule) {
        if (this.out_ != null) {
            this.out_.decreaseTab();
            this.endElement("templateRule");
            this.out_.println();
        }
    }

    private void startElementOpen(String string, Location location) {
        this.out_.printOpen();
        this.out_.print(string);
        if (location != null) {
            if (location.uri != null) {
                this.out_.printAttribute("uri", this.getUriId(location.uri));
            }
            if (location.line != -1) {
                this.out_.printAttribute("line", String.valueOf(location.line));
            }
        }
    }

    private void startElementClose() {
        this.out_.printClose();
    }

    private void endElement(String string) {
        this.out_.printOpenSlash();
        this.out_.print(string);
        this.out_.printClose();
    }

    private String getUriId(String string) {
        String string2;
        int n = this.uris_.indexOf(string);
        if (n == -1) {
            string2 = String.valueOf(this.uris_.size());
            this.uris_.addElement(string);
            this.uriIds_.addElement(string2);
        } else {
            string2 = (String)this.uriIds_.elementAt(n);
        }
        return string2;
    }

    private void printUris() {
        int n = this.uris_.size();
        for (int i = 0; i < n; ++i) {
            this.startElementOpen("uri", null);
            this.out_.printAttribute("id", (String)this.uriIds_.elementAt(i));
            this.startElementClose();
            this.out_.printText((String)this.uris_.elementAt(i));
            this.endElement("uri");
            this.out_.println();
        }
    }
}

