//LabPlot : Line.h

#ifndef LINE_H
#define LINE_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"
#include "Arrow.h"

class Line
{
public:
	Line(Point s=0,Point e=0,QColor c=QColor("black"),int w=1);
	~Line();
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	QDomElement saveXML(QDomDocument doc);
	void openXML(QDomNode node);
	Point startPoint() { return start; }
	Point endPoint() { return end; }
	void setStartPoint(double x, double y) { start=Point(x,y);}
	void setEndPoint(double x, double y) { end=Point(x,y);}
	int Width() { return width; }
	void setWidth(int w) { width=w; }
	QColor Color() { return color; }
	void setColor(QColor c) { color=c; }
	void setColor(QString c) { color=QColor(c); }
	Arrow* startArrow() { return sarrow; }
	Arrow* endArrow() { return earrow; }
	void setStartArrow(Arrow *a) { sarrow = a; }
	void setEndArrow(Arrow *e) { earrow = e; }
	void draw(QPainter *p, int w, int h);
	bool inside(int x, int y, int w, int h);	
protected:
	Point start, end;
	QColor color;
	int width;
	Arrow *sarrow, *earrow;
};

#endif //LINE_H
