//LabPlot : AxesDialog.h

#ifndef AXESDIALOG_H
#define AXESDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>
#include <klistbox.h>
#include "MainWin.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class AxesDialog: public Dialog
{
	Q_OBJECT
public:
	AxesDialog(MainWin *mw, const char *name, int axesnr);
	void updateDialog(int i=-1);
public slots:
	void selectTickFont();
	void updateAxis(int i=-1);
	void updateTickType(int tt);
	void update_timeformat();
	void updateScale(int i);
	void axisEnabled(bool on);
	void centerEnabled(bool on);

	void Enable(bool e=true) { axiscb->setChecked(e); }
	void enableAxis(bool e=true) { Enable(e); }
	void setPosition(int v) { positioncb->setCurrentItem(v); }
	int Position() { return positioncb->currentItem(); }
	void setScale(int v) { ascb->setCurrentItem(v); }
	int Scale() { return ascb->currentItem(); }
	void setScaling(double v) { scalingle->setText(QString::number(v)); }
	double Scaling() { return scalingle->text().toDouble(); }
	void setShift(double v) { shiftle->setText(QString::number(v)); }
	double Shift() { return shiftle->text().toDouble(); }
	void setRange(double a, double b) 
		{ minle->setText(QString::number(a)); maxle->setText(QString::number(b)); }
	LRange *Range() { return new LRange(minle->text().toDouble(),maxle->text().toDouble()); }
	void setMin(double a) { minle->setText(QString::number(a)); }
	double getMin() { return minle->text().toDouble(); }
	void setMax(double b) { maxle->setText(QString::number(b)); }
	double getMax() { return maxle->text().toDouble(); }
	void enableCenter(bool e=true) { centercb->setChecked(e); }
	bool Center() { return centercb->isChecked(); }
	void setLabel(Label *l) { rtw->setLabel(l); }
	Label *getLabel() { return rtw->getLabel(); }
	void setTickPosition(int i) { tickposcb->setCurrentItem(i); }
	int TickPosition() { return tickposcb->currentItem(); }
	void setTickStyle(int i) { ticktypecb->setCurrentItem(i); }
	int TickStyle() { return ticktypecb->currentItem(); }

	void enableMajorTicks(bool e=true) { majortickscb->setChecked(e); }
	bool MajorTicksEnabled() { return majortickscb->isChecked(); }
	void setMajorTicks(int n) { majorle->setText(QString::number(n)); }
	int MajorTicks() { return majorle->text().toInt(); }
	void setMajorTickLength(int n) { majorticklengthle->setText(QString::number(n)); }
	int MajorTickLength() { return majorticklengthle->text().toInt(); }
	void enableMinorTicks(bool e=true) { minortickscb->setChecked(e); }
	bool MinorTicksEnabled() { return minortickscb->isChecked(); }
	void setMinorTicks(int n) { minorle->setText(QString::number(n)); }
	int MinorTicks() { return minorle->text().toInt(); }
	void setMinorTickLength(int n) { minorticklengthle->setText(QString::number(n)); }
	int MinorTickLength() { return minorticklengthle->text().toInt(); }
	void setTickColor(QColor c) { tcb->setColor(c); }
	QColor TickColor() { return tcb->color(); }

	void enableTickLabel(bool e=true) { ticklabelcb->setChecked(e); }
	bool TickLabelEnabled() { return ticklabelcb->isChecked(); }
	void setTickLabelFont(QFont f) { tf=f; }
	QFont TickLabelFont() { return tf; }
	void setTickLabelColor(QColor c) { tlcb->setColor(c); }
	QColor TickLabelColor() { return tlcb->color(); }
	void setTickLabelFormat(int i) { atlfcb->setCurrentItem(i); }
	int TickLabelFormat() { return atlfcb->currentItem(); }
	void setTimeFormat(QString t) { timeformat->setText(t); }
	QString TimeFormat() { return timeformat->text(); }
	void setTickLabelPrecision(int v) { tlpni->setValue(v); }
	int TickLabelPrecision() { return tlpni->value(); }
	void setTickLabelPosition(int v) { tlgni->setValue(v); }
	int TickLabelPosition() { return tlgni->value(); }
	void setTickLabelPrefix(QString v) { tlprefix->setText(v); }
	QString TickLabelPrefix() { return tlprefix->text(); }
	void setTickLabelSuffix(QString v) { tlsuffix->setText(v); }
	QString TickLabelSuffix() { return tlsuffix->text(); }
	void setTickLabelRotation(int r) { tlrotation->setText(QString::number(r)); }
	int TickLabelRotation() { return tlrotation->text().toInt(); }

	void enableMajorGrid(bool e=true) { majorgridcb->setChecked(e); }
	bool MajorGrid() { return majorgridcb->isChecked(); }
	void setMajorGridWidth(int w) { majorgridwidth->setValue(w); }
	int MajorGridWidth() { return majorgridwidth->value(); }
	void setMajorGridStyle(int v) { majorgridstylecb->setCurrentItem(v); }
	int MajorGridStyle() { return majorgridstylecb->currentItem(); }
	void setMajorGridColor(QColor c) { majorgridcolorcb->setColor(c); }
	QColor MajorGridColor() { return majorgridcolorcb->color(); }
	void enableMinorGrid(bool e=true) { minorgridcb->setChecked(e); }
	bool MinorGrid() { return minorgridcb->isChecked(); }
	void setMinorGridWidth(int w) { minorgridwidth->setValue(w); }
	int MinorGridWidth() { return minorgridwidth->value(); }
	void setMinorGridStyle(int v) { minorgridstylecb->setCurrentItem(v); }
	int MinorGridStyle() { return minorgridstylecb->currentItem(); }
	void setMinorGridColor(QColor c) { minorgridcolorcb->setColor(c); }
	QColor MinorGridColor() { return majorgridcolorcb->color(); }

	void enableBorder(bool e=true) { bordercb->setChecked(e); }
	bool BorderEnabled() { return bordercb->isChecked(); }
	void setBorderColor(QColor c) { bcb->setColor(c); }
	QColor BorderColor() { return bcb->color(); }
	void setBorderWidth(int w=1) { borderwidth->setValue(w); }
	void setBorderWidth(QString w) { borderwidth->setValue(w.toInt()); }
	int BorderWidth() { return borderwidth->value(); }

	void ok_clicked() { apply_clicked(); accept(); }
	void saveSettings();
	int apply_clicked();
	int Apply() { return apply_clicked(); }
private:
	Plot *plot;
	Label *label;
	Axis *axis[12];
	int type;
	RichTextWidget *rtw;
	QLabel *majorlabel;
	KComboBox *ticktypecb, *positioncb;
	KLineEdit *scalingle, *shiftle, *tickfont, *minle, *maxle, *majorle, *minorle;
	KIntNumInput *tlpni, *tlgni;
	KLineEdit *tlprefix, *tlsuffix, *timeformat, *tlrotation;
	KComboBox *axescb;
	QCheckBox *axiscb, *centercb, *majortickscb, *minortickscb, *majorgridcb, *minorgridcb, *bordercb, *ticklabelcb;
	KIntNumInput *majortickwidth, *minortickwidth, *majorgridwidth, *minorgridwidth, *borderwidth;
	KLineEdit *majorticklengthle, *minorticklengthle;
	KColorButton *tcb, *tlcb, *gcb, *bcb;
	KComboBox *atlfcb, *ascb, *tickposcb;
	QFont tf;
	KComboBox *majorgridstylecb, *minorgridstylecb;
	KColorButton *majorgridcolorcb, *minorgridcolorcb;
};
#endif //AXESDIALOG_H
