//LabPlot : ImportDialog.h

#ifndef IMPORTDIALOG_H
#define IMPORTDIALOG_H

#include "FilterKexiDB.h"
#include "Dialog.h"

/*! Main class for Data Import*/
class ImportDialog: public Dialog
{
	Q_OBJECT
public:
	ImportDialog(MainWin *mw, QString filename="", InputFilter filter=FUSER, const char *name=0);
public slots :
	void setNewSpreadsheet(bool e=true) { newspread->setChecked(e); }
	void Apply() { if (!apply_clicked()) accept(); }
private:
	FilterKexiDB *kexi;					//KexiDB
	KComboBox *driver, *databases, *tables;
	QLabel *connectionlabel, *tablelabel;
	KLineEdit *host, *user, *password;
	QCheckBox *newspread;				// whether to create a new spreadsheet; otherwise active used
private slots :	
	int apply_clicked();
	void saveSettings();
	void wizardKexiDB(const QString &name);
	void finishKexiDB();
};
#endif //IMPORTDIALOG_H
