// LabPlot : AnnotateValues.cc

#include <qpainter.h>
#include <qtextstream.h>
#include <kdebug.h>
#include "AnnotateValues.h"

AnnotateValues::AnnotateValues(int t, int p,int d)
{
	type=t;
	position=p;
	distance=d;
}

void AnnotateValues::draw(QPainter *p,int X, int Y, double x, double y, double z) {
	int ax=X,ay=Y;

//	kdDebug()<<"AnnotateValues::draw()"<<endl;
//	kdDebug()<<"Type Position Distance : "<<type<<' '<<position<<' '<<distance<<endl;
	
	switch (position) {
	case 0:
		ay=Y-distance;
		break;
	case 1:
		ay=Y+distance;
	case 2:
		ax=X-distance;
	case 3:
		ax=X+distance;
	}
	
	switch(type) {
	case 1:
		p->drawText(ax,ay,QString::number(x));
		break;
	case 2:
		p->drawText(ax,ay,QString::number(y));
		break;
	case 3:
		p->drawText(ax,ay,QString::number(z));
		break;
	case 4:
		p->drawText(ax,ay,QString::number(x)+", "+QString::number(y));
		break;
	case 5:
		p->drawText(ax,ay,QString::number(x)+", "+QString::number(y)+","+QString::number(z));
		break;		
	}
}

void AnnotateValues::save(QTextStream *t) {
	*t<<type<<' '<<position<<' '<<distance<<endl;
}

void AnnotateValues::open(QTextStream *t, int version) {
	kdDebug()<<"AnnotateValues::open() : "<<version<<endl;
	*t>>type>>position>>distance;
}

QDomElement AnnotateValues::saveXML(QDomDocument doc) {
	QDomElement avtag = doc.createElement( "Annotate" );

	QDomElement tag = doc.createElement( "Type" );
   	avtag.appendChild( tag );
  	QDomText t = doc.createTextNode( QString::number(type) );
    	tag.appendChild( t );
	tag = doc.createElement( "Position" );
   	avtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(position) );
    	tag.appendChild( t );
	tag = doc.createElement( "Distance" );
   	avtag.appendChild( tag );
  	t = doc.createTextNode( QString::number(distance) );
    	tag.appendChild( t );

	return avtag;
}

void AnnotateValues::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
//		kdDebug()<<"AV TAG = "<<e.tagName()<<endl;
//		kdDebug()<<"AV TEXT = "<<e.text()<<endl;

		if(e.tagName() == "Type")
			type = e.text().toInt();
		else if(e.tagName() == "Position")
			position = e.text().toInt();
		else if(e.tagName() == "Distance")
			distance = e.text().toInt();

		node = node.nextSibling();
	}
}
