#
# spec file for LabPlot (SUSE Linux 9.1)
#
# Copyright (c) 2006 Stefan Gerlach.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments to gerlach@mbi-berlin.de
#

%define version 1.5.1.rc2
%define release 1
Distribution:	SUSE Linux 9.1
BuildPrereq:	libjpeg-devel, ImageMagick-devel, ImageMagick-Magick++-devel, gsl, fftw3-devel, fftw3-threads-devel, qsa, audiofile-devel, netcdf
Requires:	libjasper, pstoedit, ImageMagick, ImageMagick-Magick++, gsl, fftw3, fftw3-threads, qsa, audiofile, netcdf

################################################################################

Name: 		LabPlot
URL:		http://labplot.sf.net/
Version:	%{version}
Release:	%{release}
Summary:	Function and Data Plotter
Source:		%{name}-%{version}.tar.bz2
Group:		Applications/Engineering	
License:	GPL
Packager:	Stefan Gerlach <gerlach@mbi-berlin.de>
Vendor:		http://labplot.sf.net/
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
LabPlot is a scientific program for plotting functions and to visualize and manipulate data.

Authors:
........
# TODO
     Stefan Gerlach <gerlach@mbi-berlin.de>

%prep
%setup

%build
%ifarch x86_64 sparc64 ppc64 amd64
CFLAGS="$CFLAGS -fPIC"
CXXFLAGS="$CXXFLAGS -fPIC"
./configure --prefix=/opt/kde3 --disable-static --enable-libsuffix=64 --with-qt-libraries=/usr/lib/qt3/lib64
%else
./configure --prefix=/opt/kde3 --disable-static
%endif
make


%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -f ../file.list.%{name}

%install
make DESTDIR="$RPM_BUILD_ROOT" install
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(755\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.%{name}
find . -type f -o -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files -f ../file.list.%{name}
%doc README TODO INSTALL ChangeLog CHANGES FEATURES LabPlot.lsm


%changelog
* Sun Mar 12 2006 - Stefan Gerlach
- update for 1.5.1
- improved all sections
* Fri Aug 06 2005 - Stefan Gerlach
- update for 1.5.0
* Fri Mar 25 2005 - Stefan Gerlach
- update for 1.4.1
* Sun Nov 28 2004 - Stefan Gerlach
- added qwtplot3d library, LabPlot.1
* Fri Oct 29 2004 - Stefan Gerlach
- updated to version 1.4.0
