//LabPlot : Plot2D.h

#ifndef PLOT2D_H
#define PLOT2D_H

#include <iostream>
#include "Plot.h"

using namespace std;

class Plot2D:public Plot {
public:
	Plot2D(Worksheet *p);
	~Plot2D() {}
	void saveAxes(QTextStream *t);
	void openAxes(QTextStream *t,int version);
	Axis *getAxis(int i) { return &axis[i]; }
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];}
	void setActRanges(LRange* r);
	void enableGrid(int index,bool b) { gridenabled[index] = b; }
	bool gridEnabled(int index) { return gridenabled[index]; }
	void enableBorder(int index,bool b) { borderenabled[index] = b; }
	bool borderEnabled(int index) { return borderenabled[index]; }
	void draw(QPainter *p, int w, int h);
	void drawAxes(QPainter *p, int w, int h);
	void drawBorder(QPainter *p, int w, int h);
	virtual void drawCurves(QPainter *p, int w, int h) = 0;
	void setBorder(int item, bool on);
protected:
	Axis axis[4];	// x, y, y2, x2
private:
	bool borderenabled[4];	// x, y, y2, x2
	bool gridenabled[8];	// x, xmin, y, ymin, x2, x2min, y2, y2min
};

#endif // PLOT2D_H
