//LabPlot : ExplorerDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "ExplorerDialog.h"
#include "Plot2DSimple.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotPie.h"
#include "PlotPolar.h"
#include "PlotTernary.h"
#include "PlotQWT3D.h"
#include "PlotGRASS.h"
#include "PlotVTK.h"
#include "PlotGL.h"

ExplorerDialog::ExplorerDialog(Worksheet *p, const char *name)
	: Dialog(p, name),mw(p->getMainWin())
{
	setCaption(i18n("Project Explorer"));

	lv = new QListView(vbox,0);
	lv->addColumn(i18n("Object"));
	lv->addColumn(i18n("Type"));
	lv->addColumn(i18n("Info"));
	lv->setRootIsDecorated( TRUE );

	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);

	menu = new QPopupMenu( lv );
       	menu->insertItem( i18n( "Delete" ) );
	connect(lv, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( rmouse( QListViewItem *, const QPoint &, int ) ) );

	initlist();

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(400,300);
}

void ExplorerDialog::initlist() {
	QWorkspace *ws = mw->getWorkspace();
	QWidgetList list = ws->windowList();

	int nrs=0,nrw=0;
	for (unsigned int i = 0; i < list.count(); ++i ) {
		kdDebug()<<" LIST : Sheet "<<i<<endl;
		QListViewItem *lvisheet = new QListViewItem(lv);
		lvisheet->setOpen(TRUE);
		if(list.at(i)->caption().contains(i18n("Spreadsheet"))) {
			Spreadsheet *spreadsheet =  ((Spreadsheet *) list.at(i));
			lvisheet->setText(0,"Spreadsheet "+QString::number(++nrs));
			lvisheet->setText(1,"Spreadsheet");
			lvisheet->setText(2,spreadsheet->Info().join(" "));
		}
		else {
			Worksheet *worksheet =  ((Worksheet *) list.at(i));
			lvisheet->setText(0,"Worksheet "+QString::number(++nrw));
			lvisheet->setText(1,"Worksheet");
			lvisheet->setText(2,worksheet->Info().join(" "));
			
			for (unsigned int j=0;j<worksheet->NrPlots();j++) {
				QListViewItem *lviplot = new QListViewItem(lvisheet);
				lviplot->setOpen(TRUE);
				lviplot->setText(0,"Plot "+QString::number(j+1));
				Plot *plot = worksheet->getPlot(j);
	
				QString ptype;
				QStringList info;
				switch(plot->Type()) {
				case P2D: ptype=i18n("2 D"); 
						info = ((Plot2DSimple *)plot)->Info();
						break;
				case PSURFACE: ptype=i18n("SURFACE"); 
						info = ((Plot2DSurface *)plot)->Info();
						break;
				case P3D: ptype=i18n("3 D"); 
						info = ((Plot2DSurface *)plot)->Info();
						break;
				case PGRASS: ptype=i18n("GRASS");
						info = ((PlotGRASS *)plot)->Info();
						break;
				case PVTK: ptype=i18n("VTK");
						info = ((PlotVTK *)plot)->Info();
						break;
				case PPIE: ptype=i18n("PIE");
						info = ((PlotPie *)plot)->Info();
						break;
				case PPOLAR: ptype=i18n("POLAR");
						info = ((PlotPolar *)plot)->Info();
						break;
				case PTERNARY: ptype=i18n("TERNARY");
						info = ((PlotTernary *)plot)->Info();
						break;
				case PGL: ptype=i18n("GL");
						info = ((PlotGL *)plot)->Info();
						break;
				case PQWT3D: ptype=i18n("QWT 3D");
						info = ((PlotQWT3D *)plot)->Info();
						break;
				}
				lviplot->setText(1,ptype);
				lviplot->setText(2,info.join(" "));
				
				// list of graphs
				kdDebug()<<"getting list of graphs for plot "<<j<<" of type "<<ptype<<endl;
				GraphList *graphlist = plot->getGraphList();
				for(unsigned int k=0;k<graphlist->getNumber();k++) {
					QListViewItem *lvigraph = new QListViewItem(lviplot);
					lvigraph->setOpen(TRUE);
					lvigraph->setText(0,"Graph "+QString::number(k+1));
					Graph *graph = graphlist->getGraph(k);
					QString gtype;
					switch (graphlist->getStruct(k) ) {
					case GRAPH2D: gtype=i18n("2 D"); 
						info = ((Graph2D *) graph)->Info();
						break;
					case GRAPH3D: gtype=i18n("3 D"); 
						info = ((Graph3D *) graph)->Info();
						break;
					case GRAPHM: gtype=i18n("MATRIX"); 
						info = ((GraphM *) graph)->Info();
						break;
					case GRAPHGRASS: gtype=i18n("GRASS"); 
						info = ((GraphGRASS *) graph)->Info();
						break;
					case GRAPHVTK: gtype=i18n("VTK"); 
						info = ((GraphVTK *) graph)->Info();
						break;
					case GRAPH4D: gtype=i18n("4 D"); 
						info = ((Graph4D *) graph)->Info();
						break;
					case GRAPHIMAGE: gtype=i18n("IMAGE"); 
						info = ((GraphIMAGE *) graph)->Info();
						break;
					}
					lvigraph->setText(1,gtype);
					lvigraph->setText(2,info.join(" "));
				}
			}
		}
	}
	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);
}

void ExplorerDialog::rmouse(QListViewItem *item, const QPoint & point, int ) {
	//if( item )
        //menu->popup( point );
	// TODO
}
