/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSRasterLayer.h,v 1.4 2002/04/23 09:28:18 com Exp $
*/

#ifndef GRASSRASTERLAYER_H
#define GRASSRASTERLAYER_H

extern "C" {
#include <gis.h>
}

#include <GRASSLayer.h>
#include <GRASSPainter.h>
#include <GRASSRasterColorMap.h>
#include <GeoXY.h>

/**
 *
 *
 **/


class GRASSRasterLayer : public GRASSLayer {
public:
  
  GRASSRasterLayer(GRASSPainter* painter, 
		   char* name,
		   char* mapset);

  virtual ~GRASSRasterLayer();

  virtual void draw(QPainter* p);

  virtual int rtti() { return GRASSRasterLayerID; };

  static const int GRASSRasterLayerID = 2;

protected:
  
private:

  int drawCell(int A_row, void *array, QPainter* p);

  GRASSRasterLayer(const GRASSRasterLayer& rhs);

  GRASSRasterLayer& operator=(const GRASSRasterLayer& rhs);
  
  GRASSPainter* _painter;

  GRASSRasterColorMap _colorMap;
  
  RASTER_MAP_TYPE data_type;

  int cellfile;

  struct Colors colors;

  void* _raster;

  int cur_D_row;

};	// end of class GRASSRasterLayer



#endif /* GRASSRASTERLAYER_H */
