/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Paul Gammans, Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <glib.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>



/**
 * gtrans_string_conflict_char:
 * @c : A character
 *
 * Returns NOT NULL if @c could create conflicts in a query string
 * and needs to be treated different (with a \).
 */
static gchar *
gtrans_string_is_char_reserved(gchar c)
{
	gchar  reserved[] = "'\"%_\\()"; 
	
	return strchr(reserved,c);
}



/**
 * gtrans_string_count_reserved_chars
 * @check    : String to check for reserved char's eg ['"%_\]
 *
 * Returns   : The count.
 * Note      : Currenty dosen't check \n \0 \t \r \b
 */
static gint
gtrans_string_count_reserved_chars(gchar *str)
{
	gint   i;
	gint   count = 0;
	
	for ( i = 0 ; str[i] != '\0' ; i++ ){
		if(gtrans_string_is_char_reserved(str[i]))
			count++;
	}
	
	return count;
}




/**
 * gtrans_string_escaped_len:
 * @str  : A character string
 *
 * Return the length of the string plus the number of 
 * reserved chars.
 */
gint
gtrans_string_escaped_len(gchar *str)
{
	return  strlen(str) + 
		gtrans_string_count_reserved_chars(str);
}




/**
 * gtrans_string_escaped_concat:
 * @tgt     : String to concatenate to
 * @src     : String to concatenate
 *
 * Concatenates @src to @tgt adding a \ before each
 * reserved (or conflictive) character.
 * Note     : Currenty dosen't check \n \0 \t \r \b
 */
gchar *
gtrans_string_escaped_concat(gchar *tgt, 
			     gchar *src)
{
	gint   i = 0, j = 0;
	gchar  c;
	
	/* find end of s */
	while (tgt[i] != '\0')
		i++;
	
	while ( (c = src[j++]) != '\0' ){
		if(gtrans_string_is_char_reserved(c))
			tgt[i++] = '\\';
		tgt[i++] = c;
	}
	
	return tgt;
}





/**
 * gtrans_string_escaped_dup:
 * @src : A character string
 *
 * Duplicates @src string and adds a \ before each conflictive
 * character.
 */
gchar *
gtrans_string_escaped_dup(gchar *src)
{
	gchar *tgt, c;
	gint   len, i = 0, j = 0;
	
	len = gtrans_string_escaped_len(src);
	tgt = g_new(gchar, len + 1);
	
	while ( (c = src[j++]) != '\0' ){
		if(gtrans_string_is_char_reserved(c))
			tgt[i++] = '\\';
		tgt[i++] = c;
	}
	
	return tgt;
}



















