/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * tcl_utils.c
 *
 * prepend_to_auto_path()
 *
 */
#include <tcl.h>
#include <utilities.h>

extern Tcl_Interp *interp;

/*
 * autopath is the directory list variable which tcl uses to 
 * look for unknown commands
 */
int
prepend_to_auto_path(const char *path)
{
  char script[256];

  sprintf(script, "set auto_path [linsert $auto_path 0 %s]", path);
  return tcl_script(script);
}


/*
 * execute script in tcl
 *
 */
int
tcl_script(char *script)
{
  int status;

  if ( (status = Tcl_GlobalEval(interp,script)) == TCL_ERROR)
    {
      fprintf(stderr, "tcl_script - error executing: %s\n", script);
      Tcl_GlobalEval(interp,"puts stderr $errorInfo");
    }

  return status;
}
 

/*
 * returns ClientData for a tcl object
 */
ClientData
get_ClientData(char *obj)
{
  Tcl_CmdInfo info;

  if (Tcl_GetCommandInfo(interp, obj, &info))
    return info.clientData;

  fprintf(stderr,"get_ClientData - bad object name %s\n",obj);
  return NULL;
}

/* we want to bypass Tcl_Eval for speed in some case, so store some cmd info */
static Tcl_CmdInfo update_info;

/*
 * tcl_update
 *
 * updates the tcl windows
 */
void
tcl_update()
{
  static char update[] = "update";
  char *argv[1];
  int argc=1;

  argv[0] = update;

  (*update_info.proc)(update_info.clientData, interp, argc, argv);
}

/*
 * get_updateinfo
 */
void
setup_tcl_update()
{
  static char update[] = "update";

  /* get info on some commands for optimization */
  Tcl_GetCommandInfo(interp, update, &update_info);
}

