// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#ifndef ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H
#define ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H

#include <Atlas/Objects/Root.h>


namespace Atlas { namespace Objects { namespace Operation { 

/** Base operation for all operators

This is base operation for all other
    operations and defines basic attributes. You can use this as
    starting point for browsing whole operation hiearchy. refno refers
    to operation this is reply for. In examples all attributes that
    are just as examples (and thus world specific) are started with 'e_'.

*/
class RootOperation : public Root
{
  public:
    /// Construct a RootOperation instance.
    RootOperation();
  protected:
    /// Constructor for sub-classes.
    RootOperation(const char *,const char *);
  public:
    /// Default destructor.
    virtual ~RootOperation();

    /// Create a new class for RootOperation.
    static RootOperation Class();

    /// Check whether the attribute "name" exists.
    virtual bool hasAttr(const std::string& name)const;
    /// Retrieve the attribute "name". Throws NoSuchAttrException if it does
    /// not exist.
    virtual Atlas::Message::Element getAttr(const std::string& name)
            const throw (NoSuchAttrException);
    /// Set the attribute "name" to the value given by"attr"
    virtual void setAttr(const std::string& name,
                         const Atlas::Message::Element& attr);
    /// Remove the attribute "name". This will not work for static attributes.
    virtual void removeAttr(const std::string& name);

    /// Send the contents of this object to a Bridge.
    virtual void sendContents(Atlas::Bridge* b) const;

    /// Convert this object to a Message::Element.
    virtual Atlas::Message::Element asObject() const;

    /// Convert this object to a Message::Element::MapType.
    virtual Atlas::Message::Element::MapType asMap() const;

    /// Set the "serialno" attribute.
    inline void setSerialno(long val);
    /// Set the "refno" attribute.
    inline void setRefno(long val);
    /// Set the "from" attribute.
    inline void setFrom(const std::string& val);
    /// Set the "to" attribute.
    inline void setTo(const std::string& val);
    /// Set the "seconds" attribute.
    inline void setSeconds(double val);
    /// Set the "future_seconds" attribute.
    inline void setFutureSeconds(double val);
    /// Set the "time_string" attribute.
    inline void setTimeString(const std::string& val);
    /// Set the "args" attribute.
    inline void setArgs(const Atlas::Message::Element::ListType& val);

    /// Retrieve the "serialno" attribute.
    inline long getSerialno() const;
    /// Retrieve the "serialno" attribute as a non-const reference.
    inline long& getSerialno();
    /// Retrieve the "refno" attribute.
    inline long getRefno() const;
    /// Retrieve the "refno" attribute as a non-const reference.
    inline long& getRefno();
    /// Retrieve the "from" attribute.
    inline const std::string& getFrom() const;
    /// Retrieve the "from" attribute as a non-const reference.
    inline std::string& getFrom();
    /// Retrieve the "to" attribute.
    inline const std::string& getTo() const;
    /// Retrieve the "to" attribute as a non-const reference.
    inline std::string& getTo();
    /// Retrieve the "seconds" attribute.
    inline double getSeconds() const;
    /// Retrieve the "seconds" attribute as a non-const reference.
    inline double& getSeconds();
    /// Retrieve the "future_seconds" attribute.
    inline double getFutureSeconds() const;
    /// Retrieve the "future_seconds" attribute as a non-const reference.
    inline double& getFutureSeconds();
    /// Retrieve the "time_string" attribute.
    inline const std::string& getTimeString() const;
    /// Retrieve the "time_string" attribute as a non-const reference.
    inline std::string& getTimeString();
    /// Retrieve the "args" attribute.
    inline const Atlas::Message::Element::ListType& getArgs() const;
    /// Retrieve the "args" attribute as a non-const reference.
    inline Atlas::Message::Element::ListType& getArgs();

protected:
    long attr_serialno;
    long attr_refno;
    std::string attr_from;
    std::string attr_to;
    double attr_seconds;
    double attr_future_seconds;
    std::string attr_time_string;
    Atlas::Message::Element::ListType attr_args;

    inline void sendSerialno(Atlas::Bridge*) const;
    inline void sendRefno(Atlas::Bridge*) const;
    inline void sendFrom(Atlas::Bridge*) const;
    inline void sendTo(Atlas::Bridge*) const;
    inline void sendSeconds(Atlas::Bridge*) const;
    inline void sendFutureSeconds(Atlas::Bridge*) const;
    inline void sendTimeString(Atlas::Bridge*) const;
    inline void sendArgs(Atlas::Bridge*) const;

};

//
// Inlined member functions follow.
//

void RootOperation::setSerialno(long val)
{
    attr_serialno = val;
}

void RootOperation::setRefno(long val)
{
    attr_refno = val;
}

void RootOperation::setFrom(const std::string& val)
{
    attr_from = val;
}

void RootOperation::setTo(const std::string& val)
{
    attr_to = val;
}

void RootOperation::setSeconds(double val)
{
    attr_seconds = val;
}

void RootOperation::setFutureSeconds(double val)
{
    attr_future_seconds = val;
}

void RootOperation::setTimeString(const std::string& val)
{
    attr_time_string = val;
}

void RootOperation::setArgs(const Atlas::Message::Element::ListType& val)
{
    attr_args = val;
}

long RootOperation::getSerialno() const
{
    return attr_serialno;
}

long& RootOperation::getSerialno()
{
    return attr_serialno;
}

long RootOperation::getRefno() const
{
    return attr_refno;
}

long& RootOperation::getRefno()
{
    return attr_refno;
}

const std::string& RootOperation::getFrom() const
{
    return attr_from;
}

std::string& RootOperation::getFrom()
{
    return attr_from;
}

const std::string& RootOperation::getTo() const
{
    return attr_to;
}

std::string& RootOperation::getTo()
{
    return attr_to;
}

double RootOperation::getSeconds() const
{
    return attr_seconds;
}

double& RootOperation::getSeconds()
{
    return attr_seconds;
}

double RootOperation::getFutureSeconds() const
{
    return attr_future_seconds;
}

double& RootOperation::getFutureSeconds()
{
    return attr_future_seconds;
}

const std::string& RootOperation::getTimeString() const
{
    return attr_time_string;
}

std::string& RootOperation::getTimeString()
{
    return attr_time_string;
}

const Atlas::Message::Element::ListType& RootOperation::getArgs() const
{
    return attr_args;
}

Atlas::Message::Element::ListType& RootOperation::getArgs()
{
    return attr_args;
}


} } } // namespace Atlas::Objects::Operation

#endif // ATLAS_OBJECTS_OPERATION_ROOTOPERATION_H
