// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000 Stefanus Du Toit

#ifndef ATLAS_MESSAGE_ENCODER_H
#define ATLAS_MESSAGE_ENCODER_H

#include <Atlas/EncoderBase.h>

namespace Atlas { namespace Message {

class Element;

/** Encoder that transmits Atlas::Message::Element.
 *
 * This encoder can be used to send Atlas::Message::Element objects representing
 * full atlas messages.
 *
 * @see Element
 * @see Atlas::Bridge
 * @see Atlas::EncoderBase
 * @author Stefanus Du Toit <sdt@gmx.net>
 */
class Encoder : public Atlas::EncoderBase
{
public:
    Encoder(Atlas::Bridge*);

    virtual ~Encoder() { }

    /// Ensure that methods in base class are not hidden
    virtual void streamMessage(const Map& m)
    { EncoderBase::streamMessage(m); }

    virtual void mapItem(const std::string& name, const Bridge::Map& m)
    { EncoderBase::mapItem(name, m); }
    virtual void mapItem(const std::string& name, const Bridge::List& l)
    { EncoderBase::mapItem(name, l); }
    virtual void mapItem(const std::string& name, long i)
    { EncoderBase::mapItem(name, i); }
    virtual void mapItem(const std::string& name, double d)
    { EncoderBase::mapItem(name, d); }
    virtual void mapItem(const std::string& name, const std::string& s)
    { EncoderBase::mapItem(name, s); }

    virtual void listItem(const Bridge::Map& m) { EncoderBase::listItem(m); }
    virtual void listItem(const Bridge::List& l) { EncoderBase::listItem(l); }
    virtual void listItem(long i) { EncoderBase::listItem(i); }
    virtual void listItem(double d) { EncoderBase::listItem(d); }
    virtual void listItem(const std::string& s) { EncoderBase::listItem(s); }

    /// Send a message (must be a map!) in stream state.
    virtual void streamMessage(const Element& obj);

    /// Send an object as a map item.
    virtual void mapItem(const std::string&, const Element&);
    /// Send an object as a list item.
    virtual void listItem(const Element&);
};

} } // namespace Atlas::Message

#endif


