/*
 * dstore.c - Ultrix global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.2 97/04/16 07:56:31 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

#if    ULTRIXV==20200
	{ X_NCACHE,	"_nch"			},
	{ X_NCSIZE,	"_nchsize"		},
	{ "nfsgops",	"_nfs_gnode_ops"	},
	{ "nproc",	"_nproc"		},
	{ "proc",	"_proc"			},
#else	/* ULTRIX!=20200 */
# if	defined(VAXULTRIX)
	{ "cgops",	"_Cdfs_gnode_ops"	},
	{ "fgops",	"_FIFO_gnode_ops"	},
	{ "fids",	"_fids"			},
	{ X_NCACHE,	"_nch"			},
	{ X_NCSIZE,	"_nchsize"		},
	{ "nfsgops",	"_NFS_gnode_ops"	},
	{ "nproc",	"_nproc"		},
	{ "proc",	"_proc"			},
	{ "ugops",	"_Ufs_gnode_ops"	},
# else	/* !defined(VAXULTRIX) */
	{ "cgops",	"Cdfs_gnode_ops"	},
	{ "fgops",	"FIFO_gnode_ops"	},
	{ "fids",	"fids"			},
	{ X_NCACHE,	"nch"			},
	{ X_NCSIZE,	"nchsize"		},
	{ "nfsgops",	"NFS_gnode_ops"		},
	{ "nproc",	"nproc"			},
	{ "proc",	"proc"			},
	{ "ugops",	"Ufs_gnode_ops"		},
# endif	/* defined(VAXULTRIX) */
#endif	/* ULTRIX==20200 */
	{ "",		""			},
	{ NULL<		NULL			}
};

struct file *Fileptr;			/* for process_file() in lib/prfp.c */
int Kd = -1;				/* /dev/kmem file descriptor */
int Mem = -1;				/* /dev/mem file descriptor */
int Swap = -1;				/* swap device file descriptor */
