#
# FILE            $Id: HTMLFormatter.py,v 1.6 1998/02/04 20:13:19 dlarsson Exp $
#
# DESCRIPTION     Formatters for MIF and HTML manual formats.
#
# AUTHOR          SEISY/LKSB Daniel Larsson
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of ABB Industrial Systems
# not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
#
# ABB INDUSTRIAL SYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL ABB INDUSTRIAL SYSTEMS BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# Copyright (C) ABB Industrial Systems AB, 1996
# Unpublished work.  All Rights Reserved.
#
# HISTORY:
# $Log: HTMLFormatter.py,v $
# Revision 1.6  1998/02/04 20:13:19  dlarsson
# Fixed definition list rendering.
# Removed " from _escape_chars, since it made links not working.
# Hopefully this is ok (HTMLgen doesn't escape " either).
#
# Revision 1.5  1998/02/04 19:15:57  dlarsson
# Removed the obsolete routine 'render_ordered_list'
#
# Revision 1.4  1998/02/04 18:19:58  dlarsson
# Removed ni features.
#
# Revision 1.3  1997/01/23 20:42:11  omfadmin
# Fixed nested lists.
#
# Revision 1.2  1996/07/08  05:32:13  omfadmin
# Added dummy render_navigation.
#
# Revision 1.1  1996/06/24  10:07:57  omfadmin
# Initial revision
#
#

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.6 $"



import time
import regsub

# Rename imported objects.
# The underscore is to hide the names
_gsub		= regsub.gsub


# Header and footer for HTML pages
_HTML_HEADER = """<HTML>
<HEADER>
<TITLE>%s</TITLE>
</HEADER>
<BODY>
<H1>%s</H1>
"""

_HTML_FOOTER = """
<HR>
<ADDRESS>Generated by HTMLFormatter at %s</ADDRESS>
</BODY>
</HTML>
""" % time.asctime(time.localtime(time.time()))

def _wrap(tag, txt):
    return '<%s>%s</%s>' % (tag, txt, tag)

_escape_chars	= {
    '&': '&amp;',	# This one must come first!!!
    '<': '&lt;',
    '>': '&gt;'
    }

class HTML:
    """Manual formatter generating HTML files."""

    file_ext = '.html'

    def __init__(self):
	"""Initialize object."""
	self._text_ = ''

    def _add_(self, txt):
	self._text_ = self._text_ + txt

    def render_title(self, manpage, title, marker):
	"Write document title"
	self._add_(_HTML_HEADER % (title, title))

    def render_navigation(self, top, prev, next):
	"""Render navigation buttons.

	~top~, ~prev~ and ~next~ are ManualPage instances."""
	pass

    def render_section(self, manpage, lvl, section, marker):
	"Print the section 'section'"
	code = 'H%d' % (lvl+1)
	code = _wrap(code, section)
	if marker:
	    code = '<A NAME="%s">%s</A>' % (section, code)
	self._add_(code+'\n')

    def render_paragraph(self, manpage, para):
	"Print a paragraph"
	self._add_(_wrap('P', _gsub('\n\n', '</P>\n<P>\n', para))+'\n')

    def render_code(self, manpage, code):
	"Print code"
	self._add_(_wrap('PRE', code)+'\n')

    def render_list(self, manpage, list):
	"Print an unordered list. 'list' is a list of strings."

	def emit_list((listtype, list), recursive):
	    from gendoc.ManualPage import UN_LIST, OR_LIST
	    if listtype == UN_LIST:
	        tag='UL'
	    else:
	        tag='OL'

	    code = '<%s>\n' % tag
	    for i in list:
	        if type(i) == type(''):
	            code = code + '<LI>%s\n' % i
	        else:
                    code = code + recursive(i, recursive)
	    return code + '</%s>\n' % tag

	code = emit_list(list, emit_list)
	self._add_(code)

    def render_deflist(self, manpage, list):
	code = ''
	for word, definition in list:
	    code = code + _wrap('DT', word)
	    code = code + _wrap('DD', definition)
	self._add_(_wrap('DL', code))

    def render_bold(self, text):
	return _wrap('STRONG', text)

    def render_italic(self, text):
	return _wrap('EM', text)

    def render_underline(self, text):
	return _wrap('STRONG', text)

    def render_internal_link(self, link, link_text):
	return '<A HREF=#"'+link+'">'+link_text+'</A>'

    def render_external_link(self, link, link_text):
	import urllib
	t, rest = urllib.splittype(link)
	host, path = urllib.splithost(rest)
	import posixpath
	base = posixpath.basename(path)
	root, ext = posixpath.splitext(base)
	if ext == '' and base:
	    ext = '.html'
	return '<A HREF="'+link+ext+'">'+link_text+'</A>'

    def end(self):
	"""Document is ready.

	Returns the resulting document as a string."""
	self._add_(_HTML_FOOTER)
	text = self._text_
	self._text_ = ''
	return text

    def convert_text(self, txt):
	# Translate HTML special characters.
	for char in _escape_chars.keys():
	    txt = _gsub(char, _escape_chars[char], txt)

	return txt

