__revision__ = "$Id: __init__.py,v 1.4 2002/07/18 18:15:59 molson Exp $"

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['ext_module_test',
                     'test_coverage_start',
                     'test_coverage_end',
                     'test_helper']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_xslt_extensions',
                     'test_container',
                     ]
    at_end_files = []
    SortTests(files, ordered_files, at_end_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

CoverageModule = 'Ft.Server.Server.SCore'

# -- run modes -------------------------------------------------------

from Server.Server.SCore import DatabaseModes
MODES = [DatabaseModes._FlatFileMode(),
         ]
