import time

from Ft.Server.Common import ResourceTypes, ValidationInfo
from Ft.Server.Server import FtServerServerException, Error

import test_helper

def test_create(tester):


    tester.startTest("Create XSLT Document")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.createDocument('sheet1',SHEET1,forcedType=ResourceTypes.ResourceType.XSLT_DOCUMENT)

    tester.compare(ResourceTypes.ResourceType.XSLT_DOCUMENT,test.hasResource('sheet1'))
    tester.compare(doc,test.fetchResource('sheet1'))

    tester.compare(ResourceTypes.ResourceType.XSLT_DOCUMENT,doc.getResourceType())
    tester.compare(1,doc.isResourceType(ResourceTypes.ResourceType.RAW_FILE))
    tester.compare(1,doc.isResourceType(ResourceTypes.ResourceType.XML_DOCUMENT))
    tester.compare(1,doc.isResourceType(ResourceTypes.ResourceType.XSLT_DOCUMENT))
    tester.compare(0,doc.isResourceType(ResourceTypes.ResourceType.CONTAINER))
    repo.txCommit()

    repo = repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    tester.compare(ResourceTypes.ResourceType.XSLT_DOCUMENT,test.hasResource('sheet1'))
    repo.txRollback()

    repo = repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/sheet1')
    test = repo.fetchResource('/test')
    tester.compare(test,sheet.getParent())
    repo.txRollback()
                  
    tester.testDone()
    return



def test_access(tester):

    tester.startTest("XSLT Document Access")

    repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/sheet1')
    tester.compare('text/xml',sheet.getImt())
    tester.compare(SHEET1,sheet.getContent())
    vi = sheet.getValidationInfo()
    test_helper.CompareValidationInfo(tester,ValidationInfo.NoValidation(),vi)
    #Just call, don't test
    sheet.getCreationDate()
    sheet.getLastModifiedDate()
    repo.txRollback()
    
    tester.testDone()


def test_modify(tester):

    tester.startTest("XSLT Document Modification")

    repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/sheet1')
    lmd = sheet.getLastModifiedDate()
    time.sleep(1)
    sheet.setContent(SHEET2)
    tester.compare(SHEET2,sheet.getContent())
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/sheet1')
    tester.compare(SHEET2,sheet.getContent())
    tester.compare(1,sheet.getLastModifiedDate() > lmd)
    repo.txRollback()
    tester.testDone()



def test_delete(tester):

    tester.startTest("Delete XSLT Document")
    repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/sheet1')
    test = sheet.getParent()
    sheet.delete()
    tester.compare(0,test.hasResource('sheet1'))
    tester.testException(sheet.getContent,(),FtServerServerException,{'code':Error.OBJECT_DELETED})
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    tester.compare(0,test.hasResource('sheet1'))
    repo.txRollback()

    tester.testDone()

def test_xml_interfaces(tester):

    tester.startTest("XSLT Document to Stylesheet")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    sheet1 = test.createDocument('sheet1',SHEET1,forcedType = ResourceTypes.ResourceType.XSLT_DOCUMENT)

    dom = sheet1.asStylesheet()
    tester.compare(1,hasattr(dom,'expandedName'))
    repo.txRollback()
    tester.testDone()





def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()



SHEET1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
  Sheet 1
  </xsl:template>
</xsl:stylesheet>"""

SHEET2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
  Sheet 2
  </xsl:template>
</xsl:stylesheet>"""

def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_modify(tester)
    test_delete(tester)
    test_xml_interfaces(tester)


