#$Header: /var/local/cvsroot/4Suite/test/Server/Common/test_documentreference.py,v 1.6 2004/11/15 18:29:58 lmorillas Exp $

import tempfile, os, time
from Ft.Server import FTSS_URI_SCHEME
from Ft.Lib.Uri import OsPathToUri, BASIC_RESOLVER
from Ft.Server.Common import DocumentReference
from Ft.Xml.Xslt import Stylesheet

from Server.Server.SCore import test_helper

def test_internal(tester):
    tester.startTest("Internal Document Reference to Dom")
    repo = test_helper.GetRepo(tester)
    dr = DocumentReference.InternalDocumentReference("/test/doc1")
    dom = dr.toDom(repo)
    tester.compare('docelem', dom.documentElement.localName)
    repo.txRollback()
    tester.testDone()

    tester.startTest("Internal Document Reference to Stylesheet")
    repo = test_helper.GetRepo(tester)
    dr = DocumentReference.InternalDocumentReference("/test/sheet1")
    dom = dr.toStylesheet(repo)
    tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
    repo.txRollback()
    tester.testDone()

    tester.startTest("Internal Document Reference to Schematron")
    repo = test_helper.GetRepo(tester)
    dr = DocumentReference.InternalDocumentReference("/test/schema1")
    dom = dr.toSchematron(repo)
    tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
    repo.txRollback()
    tester.testDone()


def test_external(tester):

    fileName = tempfile.mktemp()
    file = open(fileName, 'w')
    file.write(DOC1)
    file.close()
    try:
        tester.startTest("External Document Reference to Dom")
        repo = test_helper.GetRepo(tester)
        dr = DocumentReference.ExternalDocumentReference(OsPathToUri(fileName))
        dom = dr.toDom(repo)
        tester.compare('docelem', dom.documentElement.localName)
        repo.txRollback()
        tester.testDone()
    finally:
        os.unlink(fileName)

    fileName = tempfile.mktemp()
    file = open(fileName, 'w')
    file.write(SHEET1)
    file.close()
    try:
        tester.startTest("External Document Reference to Stylesheet")
        repo = test_helper.GetRepo(tester)
        dr = DocumentReference.ExternalDocumentReference(OsPathToUri(fileName))
        dom = dr.toStylesheet(repo)
        tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
        repo.txRollback()
        tester.testDone()
    finally:
        os.unlink(fileName)

    fileName = tempfile.mktemp()
    file = open(fileName, 'w')
    file.write(SCHEMA1)
    file.close()
    try:
        tester.startTest("External Document Reference to Schematron")
        repo = test_helper.GetRepo(tester)
        dr = DocumentReference.ExternalDocumentReference(OsPathToUri(fileName))
        dom = dr.toSchematron(repo)
        tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
        repo.txRollback()
        tester.testDone()
    finally:
        os.unlink(fileName)


def test_string(tester):
    tester.startTest("String Document Reference to Dom")
    repo = test_helper.GetRepo(tester)
    uri = FTSS_URI_SCHEME + ':///string-from-var-DOC1'
    dr = DocumentReference.StringDocumentReference(DOC1, uri)
    dom = dr.toDom(repo)
    tester.compare('docelem', dom.documentElement.localName)
    repo.txRollback()
    tester.testDone()

    tester.startTest("String Document Reference to Stylesheet")
    repo = test_helper.GetRepo(tester)
    uri = FTSS_URI_SCHEME + ':///string-from-var-SHEET1'
    dr = DocumentReference.StringDocumentReference(SHEET1, uri)
    dom = dr.toStylesheet(repo)
    tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
    repo.txRollback()
    tester.testDone()

    tester.startTest("String Document Reference to Schematron")
    repo = test_helper.GetRepo(tester)
    uri = FTSS_URI_SCHEME + ':///string-from-var-SCHEMA1'
    dr = DocumentReference.StringDocumentReference(SCHEMA1, uri)
    dom = dr.toSchematron(repo)
    tester.compare(1, isinstance(dom, Stylesheet.StylesheetElement))
    repo.txRollback()
    tester.testDone()



def init(tester):

    tester.startTest("Init")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test", 1)
    repo.createDocument('/test/doc1', DOC1)
    repo.createDocument('/test/sheet1', SHEET1)
    repo.createDocument('/test/schema1', SCHEMA1)
    repo.txCommit()
    tester.testDone()


DOC1="""<docelem v='foo'/>"""

SHEET1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
  Sheet 1
  </xsl:template>
</xsl:stylesheet>"""

SCHEMA1="""<schema xmlns='http://www.ascc.net/xml/schematron'>

  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@v'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>
    </rule>
  </pattern>

</schema>"""



def Test(tester):
    tester.startGroup("Document Reference")
    init(tester)
    test_internal(tester)
    test_external(tester)
    test_string(tester)
    tester.groupDone()
