from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
from Ft.Rdf.Statement import Statement
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Predicates')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Inference import Common
    from Ft.Rdf.Inference import Predicate
    test.testDone()

    test.startTest('Single Predicate')
    sv = Common.SkolemVariableArgument("X")
    p1 = Predicate.AndSinglePredicate("http://spam.com#wet",(sv,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    wet = Statement('http://ogbuji.net#uche', 'http://spam.com#wet', '1')
    infeng.workspace.add(wet)

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)

    test.compare(['http://ogbuji.net#uche'], sv.execute(infeng,context))
    test.testDone()

    test.startTest('Dual Predicate SV,SV')
    sv = Common.SkolemVariableArgument("X")
    sv1 = Common.SkolemVariableArgument("Y")
    p1 = Predicate.AndDualPredicate("http://spam.com#creator",(sv,sv1))

    infeng = CreateInfEng()

    #Assert directly to RDF
    book = Statement('http://ogbuji.net#uche', 'http://spam.com#creator', 'A Book')
    infeng.workspace.add(book)

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)

    test.compare(['http://ogbuji.net#uche'], sv.execute(infeng,context))
    test.compare(['A Book'], sv1.execute(infeng,context))
    test.testDone()

    test.startTest('Dual Predicate SV,""')
    sv = Common.SkolemVariableArgument("X")
    sl = Common.SkolemVariableArgument("A Book")
    p1 = Predicate.AndDualPredicate("http://spam.com#creator",(sv,sl))

    infeng = CreateInfEng()

    #Assert directly to RDF
    infeng.workspace.add(book)

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)

    test.compare(['http://ogbuji.net#uche'], sv.execute(infeng,context))
    test.testDone()


    #More complex test to test the propogation of skolem variables
    test.startTest('And Single Predicate')
    sv = Common.SkolemVariableArgument("X")
    p1 = Predicate.AndSinglePredicate("RUNNING",(sv,))
    p2 = Predicate.AndSinglePredicate("SWEATING",(sv,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    mikerun = Statement('mike', 'RUNNING', '1')
    ucherun = Statement('uche', 'RUNNING', '1')
    mikesweat = Statement('mike', 'SWEATING', '1')
    infeng.workspace.add([mikerun,ucherun,mikesweat])

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)
    p2.execute(infeng,context)
    
    test.compare(['mike'], sv.execute(infeng,context))
    test.testDone()

    test.startTest('Or Single Predicate')
    sv = Common.SkolemVariableArgument("X")
    p1 = Predicate.OrSinglePredicate("RUNNING",(sv,))
    p2 = Predicate.OrSinglePredicate("SWEATING",(sv,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    jeremysweat = Statement('jeremy', 'SWEATING', '1')
    infeng.workspace.add([mikerun,ucherun,jeremysweat])

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)
    p2.execute(infeng,context)

    test.compare(['mike','uche','jeremy'], sv.execute(infeng,context))
    test.testDone()

    test.startTest('Not Single Predicate')
    sv = Common.SkolemVariableArgument("X")
    p1 = Predicate.OrSinglePredicate("RUNNING",(sv,))
    p2 = Predicate.NotSinglePredicate("SWEATING",(sv,))

    infeng = CreateInfEng()

    #Assert directly to RDF
    uchesweat = Statement('uche', 'SWEATING', '1')
    infeng.workspace.add([mikerun,ucherun,uchesweat])

    context = Common.Context()
    context.skolemVariables = {}
    p1.execute(infeng,context)
    p2.execute(infeng,context)
    test.compare(['mike'], sv.execute(infeng,context))

    test.testDone()
    test.groupDone()
    





if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

