import os

odl_string = '''
module Test {
enum WeekDays {Mon,Tue,Wed,Thu,Fri,Sat,Sun};

class Professor {
  attribute WeekDays day_off;
};
};
'''

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

import sys, test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):

    
    tester.startGroup("Enumeration %s Driver" % tester.test_data['driver'])

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Professor
        import Test
        reload(Professor)
        reload(Test)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()


    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()

        tester.startTest("Create classes")

        p = Professor.new(db)

        p.day_off = Test.WeekDays.Wed

        tester.compare(p.day_off, Test.WeekDays.Wed, "Invalid Enum value")


        tx.commit()
        id = p._4ods_getId()
        tester.testDone()

        tester.startTest("Loading Enum")
        tx = db.new()
        tx.begin()
        p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
        tester.compare(p.day_off, Test.WeekDays.Wed, "Invalid Enum value")
        tester.testDone()
        tester.groupDone()
        tx.abort()
    finally:
        db.close()


