
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Parameter
from Ft.Ods.MetaData import Direction
from Ft.Ods.MetaData import Operation
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_specifier
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        def GetParameter(db,values):
            from Ft.Ods.MetaData import Parameter
            from Ft.Ods.MetaData import Direction
            return Parameter.Parameter(db,None,parameter_mode = Direction.mode_in)

        test_specifier.Test(tester,db,GetParameter)


        tester.startGroup("Parameter Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,GetParameter,'operation',Operation.Operation)

        tester.startTest("parameter_mode")
        tx = db.new()
        tx.begin()
        i = Parameter.Parameter(db,None,parameter_mode = Direction.mode_in)
        tester.compare(Direction.mode_in, i.parameter_mode)
        tx.abort()
        tester.testDone()

        tester.groupDone()
    finally:
        db.close()



