/* Cyclic garbage collection support compatibility
   for versions of Python before 2.2.
*/

#ifndef __DOM__COMPAT__
#define __DOM__COMPAT__

#include "Python.h"



#if (PY_MAJOR_VERSION >= 2 && PY_MINOR_VERSION >= 2)
/* Python >= 2.2 */

/* tp_basicsize
   Nothing really needs to be done for this, however pre-2.2
   requires a different value.  Hence we define a macro.
*/
#define GC_TP_BASICSIZE sizeof

/* tp_flags */
/* nothing to change here */

/* object construction */
/* nothing to change here */




#else
/* pre-2.2 Python */

/* tp_basicsize */
#define GC_TP_BASICSIZE(x) sizeof(x) + PyGC_HEAD_SIZE

/* tp_flags */
#define Py_TPFLAGS_HAVE_GC Py_TPFLAGS_GC

/* object contruction */
#define PyObject_GC_New      PyObject_New
#define PyObject_GC_Del      PyObject_Del
#define PyObject_GC_Track    PyObject_GC_Init
#define PyObject_GC_UnTrack  PyObject_GC_Fini




#endif /* version >= 2.2 */

#endif /* __DOM__COMPAT__ */
