<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:f="http://xmlns.4suite.org/4ss">


  <xsl:include href="holidays.xsl"/>

  <xsl:param name="year"/>
  <xsl:param name="month"/>
  <xsl:param name="style" select="'dayton'"/>

  <xsl:variable name="base_year" select="1970"/>
  <xsl:variable name="base_month" select="1"/>
  <xsl:variable name="base_day_of_week" select="4"/> <!-- 1/1/1970 was a Thursday -->

  <xsl:variable name="page_bg" select="'#ffffff'"/>
  <xsl:variable name="header_bg" select="'#e7ff99'"/>
  <xsl:variable name="cell_bg" select="'#efefef'"/>

  <xsl:variable name="numDays">
    <xsl:call-template name="getNumDays"/>
  </xsl:variable>

  <xsl:variable name="startDay">
    <xsl:call-template name="getStartDay"/>
  </xsl:variable>

  <xsl:output method="html"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>RadiCal</title>
        <link rel="stylesheet" href="{$style}.css"/>
      </head>
      <body class="MCPage">
        <center>
          <table class="MCOuter" width="80%">
            <TR class="MCTop">
              <TD align="left">
                <xsl:variable name="prevYear">
                  <xsl:value-of select="$year - 1"/>
                </xsl:variable>
                <A HREF="null.xml?xslt=month.xsl&amp;month={$month}&amp;year={$prevYear}&amp;style={$style}">
                  &lt;&lt;&#160;<xsl:value-of select="$prevYear"/>
                </A>
              </TD>
              <TD align="left">
                <xsl:variable name="prevMonth">
                  <xsl:choose>
                    <xsl:when test="$month=1">
                      <xsl:text>12</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$month - 1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:variable name="prevMonthYear">
                  <xsl:choose>
                    <xsl:when test="$prevMonth=1">
                      <xsl:value-of select="$year - 1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$year"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <A HREF="null.xml?xslt=month.xsl&amp;month={$prevMonth}&amp;year={$prevMonthYear}&amp;style={$style}">
                  &lt;&#160;<xsl:call-template name="getMonthAbbrev">
                    <xsl:with-param name="month" select="$prevMonth"/>
                  </xsl:call-template>
                </A>
              </TD>
              <TD align="center">
                <SPAN class="MCTitle">
                  <xsl:call-template name="getMonthName"/>
                  <xsl:text>, </xsl:text>
                  <xsl:value-of select="$year"/>
                </SPAN>
              </TD>
              <TD align="right">
                <xsl:variable name="nextMonth">
                  <xsl:choose>
                    <xsl:when test="$month=12">
                      <xsl:text>1</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$month + 1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:variable name="nextMonthYear">
                  <xsl:choose>
                    <xsl:when test="$nextMonth=1">
                      <xsl:value-of select="$year + 1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$year"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <A HREF="null.xml?xslt=month.xsl&amp;month={$nextMonth}&amp;year={$nextMonthYear}&amp;style={$style}">
                  <xsl:call-template name="getMonthAbbrev">
                    <xsl:with-param name="month" select="$nextMonth"/>
                  </xsl:call-template>&#160;&gt;
                </A>
              </TD>
              <TD align="right">
                <xsl:variable name="nextYear">
                  <xsl:value-of select="$year + 1"/>
                </xsl:variable>
                <A HREF="null.xml?xslt=month.xsl&amp;month={$month}&amp;year={$nextYear}&amp;style={$style}">
                  <xsl:value-of select="$nextYear"/>&#160;&gt;&gt;
                </A>
              </TD>
            </TR>
            <TR>
              <TD colspan="5" align="center">
                <table class="MCMain" cellpadding="4">
                  <xsl:if test="$style='dayton' or $style='redmond'">
                    <xsl:attribute name="border">2</xsl:attribute>
                  </xsl:if>
                  <xsl:if test="$style='oregon' or $style='santafe'
                                or $style='newyork'">
                    <xsl:attribute name="cellspacing">2</xsl:attribute>
                  </xsl:if>
                  <TR class="MCHead">
                    <TH class="MCHead">Sun</TH>
                    <TH class="MCHead">Mon</TH>
                    <TH class="MCHead">Tue</TH>
                    <TH class="MCHead">Wed</TH>
                    <TH class="MCHead">Thu</TH>
                    <TH class="MCHead">Fri</TH>
                    <TH class="MCHead">Sat</TH>
                  </TR>
                  <xsl:call-template name="getCalRows">
                    <xsl:with-param name="start" select="1 - $startDay"/>
                    <xsl:with-param name="end" select="$numDays"/>
                  </xsl:call-template>
                </table>
              </TD>
            </TR>
          </table>
        </center>
      </body>
    </html>
  </xsl:template>

  <!--
       name: getCalRows
       context: month
       params: start (integer)  - the date on the Sunday in the first row.
                                  should be negative if the first day of the
                                  month is not Sunday.
               end (integer)    - equal to the number of days in the month
       description: Builds a set of HTML rows, each with seven cells, each
                    of which is labeled with the date.
  -->
  <xsl:template name="getCalRows">
    <xsl:param name="start" select="1"/>
    <xsl:param name="end" select="31"/>
    <TR class="MCBody">
      <xsl:call-template name="buildRow">
        <xsl:with-param name="date" select="$start"/>
        <xsl:with-param name="rowlimit" select="$start + 6"/>
        <xsl:with-param name="end" select="$end"/>
      </xsl:call-template>
    </TR>
    <xsl:if test="$start + 6 &lt; $end">
      <xsl:call-template name="getCalRows">
        <xsl:with-param name="start" select="$start + 7"/>
        <xsl:with-param name="end" select="$end"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="buildRow">
    <xsl:param name="date"/>
    <xsl:param name="rowlimit"/>
    <xsl:param name="end"/>
    <xsl:param name="day_of_week" select="0"/>
    <xsl:variable name="holiday">
      <xsl:call-template name="whichHoliday">
        <xsl:with-param name="date" select="$date"/>
        <xsl:with-param name="day_of_week" select="$day_of_week"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="datestring">
      <xsl:value-of select="$year"/>
      <xsl:text>-</xsl:text>
      <xsl:call-template name="twoD">
        <xsl:with-param name="num" select="$month"/>
      </xsl:call-template>
      <xsl:text>-</xsl:text>
      <xsl:call-template name="twoD">
        <xsl:with-param name="num" select="$date"/>
      </xsl:call-template>
    </xsl:variable>
    <!-- <xsl:variable name="events" select="f:rdf.match(f:any()/Date=$date_string,  -->
    <TD class="MCBody" align="left" valign="top" width="14%">
      <xsl:if test="$date &gt;= 1 and $date &lt;= $end">
        <xsl:value-of select="$date"/>
      </xsl:if>
      <xsl:if test="$holiday">
        <DIV class="Holiday">
          <xsl:value-of select="$holiday"/>
        </DIV>
      </xsl:if>
      <BR/>
    </TD>
    <xsl:if test="$date &lt; $rowlimit">
      <xsl:call-template name="buildRow">
        <xsl:with-param name="date" select="$date + 1"/>
        <xsl:with-param name="rowlimit" select="$rowlimit"/>
        <xsl:with-param name="end" select="$end"/>
        <xsl:with-param name="day_of_week" select="$day_of_week + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!--
       name: getNumDays
       context: any
       params: year, month (integers): the year and month whose calendar you
       want to display
       desc: returns the number of days in the given month
  -->
  <xsl:template name="getNumDays">
    <xsl:choose>
      <xsl:when test="$month=2">
        <xsl:variable name="leap_day">
          <xsl:call-template name="isLeapYear"/>
        </xsl:variable>
        <xsl:value-of select="28 + $leap_day"/>
      </xsl:when>
      <xsl:when
        test="$month=4 or $month=6 or $month=9 or $month=11">
        <xsl:value-of select="30"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>31</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="getStartDay">
    <xsl:variable name="base_year" select="1970"/>
    <xsl:variable name="base_month" select="1"/>
    <xsl:variable name="days_difference">
      <xsl:call-template name="getDaysDifference"/>
    </xsl:variable>
    <xsl:value-of select="($days_difference + $base_day_of_week) mod 7"/>
  </xsl:template>

  <xsl:template name="getDaysDifference">
    <xsl:variable name="years_difference" select="$year - $base_year"/>
    <xsl:variable name="leap_days"
      select="(floor(($year - 1) div 4) - floor(($year - 1) div 100) + floor(($year - 1) div 1000))
              - (floor($base_year div 4) - floor($base_year div 100) + floor($base_year div 1000))"/>
    <xsl:variable name="day_of_year">
      <xsl:call-template name="getDaysFromJan1"/>
    </xsl:variable>
    <xsl:value-of select="$years_difference * 365 + $leap_days + $day_of_year"/>
  </xsl:template>

  <xsl:template name="getDaysFromJan1">
    <xsl:variable name="leap_day">
      <xsl:call-template name="isLeapYear"/>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$month=1">
        <xsl:value-of select="0"/>
      </xsl:when>
      <xsl:when test="$month=2">
        <xsl:value-of select="31"/>
      </xsl:when>
      <xsl:when test="$month=3">
        <xsl:value-of select="59 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=4">
        <xsl:value-of select="90 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=5">
        <xsl:value-of select="120 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=6">
        <xsl:value-of select="151 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=7">
        <xsl:value-of select="181 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=8">
        <xsl:value-of select="212 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=9">
        <xsl:value-of select="243 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=10">
        <xsl:value-of select="273 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=11">
        <xsl:value-of select="304 + $leap_day"/>
      </xsl:when>
      <xsl:when test="$month=12">
        <xsl:value-of select="334 + $leap_day"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="isLeapYear">
    <xsl:choose>
      <xsl:when test="($year mod 4) = 0 and (($year mod 100) != 0 or ($year mod 1000) = 0)">
        <xsl:value-of select="1"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="getMonthName">
    <xsl:choose>
      <xsl:when test="$month=1">
        <xsl:text>January</xsl:text>
      </xsl:when>
      <xsl:when test="$month=2">
        <xsl:text>February</xsl:text>
      </xsl:when>
      <xsl:when test="$month=3">
        <xsl:text>March</xsl:text>
      </xsl:when>
      <xsl:when test="$month=4">
        <xsl:text>April</xsl:text>
      </xsl:when>
      <xsl:when test="$month=5">
        <xsl:text>May</xsl:text>
      </xsl:when>
      <xsl:when test="$month=6">
        <xsl:text>June</xsl:text>
      </xsl:when>
      <xsl:when test="$month=7">
        <xsl:text>July</xsl:text>
      </xsl:when>
      <xsl:when test="$month=8">
        <xsl:text>August</xsl:text>
      </xsl:when>
      <xsl:when test="$month=9">
        <xsl:text>September</xsl:text>
      </xsl:when>
      <xsl:when test="$month=10">
        <xsl:text>October</xsl:text>
      </xsl:when>
      <xsl:when test="$month=11">
        <xsl:text>November</xsl:text>
      </xsl:when>
      <xsl:when test="$month=12">
        <xsl:text>December</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="getMonthAbbrev">
    <xsl:param name="month"/>
    <xsl:variable name="fullName">
      <xsl:call-template name="getMonthName">
        <xsl:with-param name="month" select="$month"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="substring($fullName,1,3)"/>
  </xsl:template>

  <xsl:template name="getDayName">
    <xsl:param name="day_of_week"/>
    <xsl:choose>
      <xsl:when test="$day_of_week=0">
        <xsl:text>Sunday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=1">
        <xsl:text>Monday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=2">
        <xsl:text>Tuesday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=3">
        <xsl:text>Wednesday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=4">
        <xsl:text>Thursday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=5">
        <xsl:text>Friday</xsl:text>
      </xsl:when>
      <xsl:when test="$day_of_week=6">
        <xsl:text>Saturday</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="getDayAbbrev">
    <xsl:param name="day_of_week"/>
    <xsl:variable name="fullName">
      <xsl:call-template name="getDayName">
        <xsl:with-param name="day_of_week" select="$day_of_week"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="substring($fullName,1,3)"/>
  </xsl:template>

  <!-- Convert a one-digit number to two digits -->
  <xsl:template name="twoD">
    <xsl:param name="num"/>
    <xsl:if test="$num &lt; 10">
      <xsl:text>0</xsl:text>
    </xsl:if>
    <xsl:value-of select="$num"/>
  </xsl:template>

</xsl:stylesheet>
