ERROR_DOCUMENT = """<!DOCTYPE HTML PUBLIC '-//IETF//DTD HTML 2.0//EN'>
<HTML><HEAD>
<TITLE>%(code)s %(title)s</TITLE>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD><BODY>
<H1>%(title)s</H1>
%(body)s
<HR>
<ADDRESS>
%(version)s Server at <A HREF=\"mailto:%(admin)s\">%(name)s</A> Port %(port)s
</ADDRESS>
</BODY></HTML>
"""

# 1xx: Informational
HTTP_CONTINUE                      = 100
HTTP_SWITCHING_PROTOCOLS           = 101
HTTP_PROCESSING                    = 102

# 2xx: Success
HTTP_OK                            = 200
HTTP_CREATED                       = 201
HTTP_ACCEPTED                      = 202
HTTP_NON_AUTHORITATIVE             = 203
HTTP_NO_CONTENT                    = 204
HTTP_RESET_CONTENT                 = 205
HTTP_PARTIAL_CONTENT               = 206
HTTP_MULTI_STATUS                  = 207

# 3xx: Redirection
HTTP_MULTIPLE_CHOICES              = 300
HTTP_MOVED_PERMANENTLY             = 301
HTTP_MOVED_TEMPORARILY             = 302
HTTP_SEE_OTHER                     = 303
HTTP_NOT_MODIFIED                  = 304
HTTP_USE_PROXY                     = 305
HTTP_TEMPORARY_REDIRECT            = 307

# 4xx: Client Error
HTTP_BAD_REQUEST                   = 400
HTTP_UNAUTHORIZED                  = 401
HTTP_PAYMENT_REQUIRED              = 402
HTTP_FORBIDDEN                     = 403
HTTP_NOT_FOUND                     = 404
HTTP_METHOD_NOT_ALLOWED            = 405
HTTP_NOT_ACCEPTABLE                = 406
HTTP_PROXY_AUTHENTICATION_REQUIRED = 407
HTTP_REQUEST_TIME_OUT              = 408
HTTP_CONFLICT                      = 409
HTTP_GONE                          = 410
HTTP_LENGTH_REQUIRED               = 411
HTTP_PRECONDITION_FAILED           = 412
HTTP_REQUEST_ENTITY_TOO_LARGE      = 413
HTTP_REQUEST_URI_TOO_LARGE         = 414
HTTP_UNSUPPORTED_MEDIA_TYPE        = 415
HTTP_RANGE_NOT_SATISFIABLE         = 416
HTTP_EXPECTATION_FAILED            = 417
HTTP_UNPROCESSABLE_ENTITY          = 422
HTTP_LOCKED                        = 423
HTTP_FAILED_DEPENDENCY             = 424

# 5xx: Server Error
HTTP_INTERNAL_SERVER_ERROR         = 500
HTTP_NOT_IMPLEMENTED               = 501
HTTP_BAD_GATEWAY                   = 502
HTTP_SERVICE_UNAVAILABLE           = 503
HTTP_GATEWAY_TIME_OUT              = 504
HTTP_VERSION_NOT_SUPPORTED         = 505
HTTP_VARIANT_ALSO_VARIES           = 506
HTTP_INSUFFICIENT_STORAGE          = 507
HTTP_NOT_EXTENDED                  = 510

# Aliases
DOCUMENT_FOLLOWS    = HTTP_OK
PARTIAL_CONTENT     = HTTP_PARTIAL_CONTENT
MULTIPLE_CHOICES    = HTTP_MULTIPLE_CHOICES
MOVED               = HTTP_MOVED_PERMANENTLY
REDIRECT            = HTTP_MOVED_TEMPORARILY
USE_LOCAL_COPY      = HTTP_NOT_MODIFIED
BAD_REQUEST         = HTTP_BAD_REQUEST
AUTH_REQUIRED       = HTTP_UNAUTHORIZED
FORBIDDEN           = HTTP_FORBIDDEN
NOT_FOUND           = HTTP_NOT_FOUND
METHOD_NOT_ALLOWED  = HTTP_METHOD_NOT_ALLOWED
NOT_ACCEPTABLE      = HTTP_NOT_ACCEPTABLE
LENGTH_REQUIRED     = HTTP_LENGTH_REQUIRED
PRECONDITION_FAILED = HTTP_PRECONDITION_FAILED
SERVER_ERROR        = HTTP_INTERNAL_SERVER_ERROR
NOT_IMPLEMENTED     = HTTP_NOT_IMPLEMENTED
BAD_GATEWAY         = HTTP_BAD_GATEWAY
VARIANT_ALSO_VARIES = HTTP_VARIANT_ALSO_VARIES

Responses = {
    # Informational
    100 : ('Continue', ''),
    101 : ('Switching Protocols', ''),
    102 : ('Processing', ''),

    # Success
    200 : ('OK', ''),
    201 : ('Created', ''),
    202 : ('Accepted', ''),
    203 : ('Non-Authoritative Information', ''),
    204 : ('No Content', ''),
    205 : ('Reset Content', ''),
    206 : ('Partial Content', ''),
    207 : ('Multi-Status', ''),

    # Redirection
    300 : ('Multiple Choices',
           "%(variants)s"),
    301 : ('Moved Permanently',
           "The document has moved <A HREF=\"%(location)s\">here</A>.<P>"),
    302 : ('Found',
           "The document has moved <A HREF=\"%(location)s\">here</A>.<P>"),
    303 : ('See Other',
           "The answer to your request is located "
           "<A HREF=\"%(location)s\">here</A>.<P>"),
    304 : ('Not Modified', ''),
    305 : ('Use Proxy',
           "This resource is only accessible through the proxy\n"
           "%(location)s<BR>\n"
           "You will need to configure your client to use that proxy.<P>\n"),
    306 : ('unused', 'unused'),
    307 : ('Temporary Redirect',
           "The document has moved <A HREF=\"%(location)s\">here</A>.<P>"),

    # Client Errors
    400 : ('Bad Request',
           "Your browser sent a request that "
           "this server could not understand.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    401 : ('Authorization Required',
           "This server could not verify that you\n"
           "are authorized to access the document\n"
           "requested.  Either you supplied the wrong\n"
           "credentials (e.g., bad password), or your\n"
           "browser doesn't understand how to supply\n"
           "the credentials required.<P>\n"),
    402 : ('Payment Required',
           'No payment -- see charging schemes'),
    403 : ('Forbidden',
           "You don't have permission to access %(uri)s\n"
           "on this server.<P>\n"),
    # keywords: uri
    404 : ('Not Found',
           "The requested URL %(uri)s was not found on this server.<P>\n"),
    # keywords: method, uri
    405 : ('Method Not Allowed',
           "The requested method %(method)s is not "
           "allowed for the URL %(uri)s.<P>\n"),
    # keywords: uri, variants
    406 : ('Not Acceptable',
           "An appropriate representation of the "
           "requested resource %(uri)s "
           "could not be found on this server.<P>\n"
           "%(variants)s"),
    407 : ('Proxy Authentication Required',
           "This server could not verify that you\n"
           "are authorized to access the document\n"
           "requested.  Either you supplied the wrong\n"
           "credentials (e.g., bad password), or your\n"
           "browser doesn't understand how to supply\n"
           "the credentials required.<P>\n"),
    408 : ('Request Time-out',
           "I'm tired of waiting for your request.\n"),
    409 : ('Conflict', ''),
    410 : ('Gone',
           "The requested resource<BR>%(uri)s<BR>\n"
           "is no longer available on this server "
           "and there is no forwarding address.\n"
           "Please remove all references to this resource.\n"),
    # keywords: method, error
    411 : ('Length Required',
           "A request of the requested method %(method)s"
           " requires a valid Content-length.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    412 : ('Precondition Failed',
           "The precondition on the request for the URL %(uri)s"
           " evaluated to false.<P>\n"),
    413 : ('Request Entity Too Large',
           "The requested resource<BR>%(uri)s<BR>\n",
           "does not allow request data with %(method)s"
           " requests, or the amount of data provided in\n"
           "the request exceeds the capacity limit.\n"),
    414 : ('Request-URI Too Large',
           "The requested URL's length exceeds the capacity\n"
           "limit for this server.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    415 : ('Unsupported Media Type',
           "The supplied request data is not in a format\n"
           "acceptable for processing by this resource.\n"),
    416 : ('Requested Range Not Satisfiable',
           "None of the range-specifier values in the Range\n"
           "request-header field overlap the current extent\n"
           "of the selected resource.\n"),
    417 : ('Expectation Failed',
           "The expectation given in the Expect request-header"
           "\nfield could not be met by this server.<P>\n"
           "The client sent<PRE>\n"
           "    Expect: %(expect)s\n</PRE>\n"
           "but we only allow the 100-continue expectation.\n"),
    418 : ('unused', 'unused'),
    419 : ('unused', 'unused'),
    420 : ('unused', 'unused'),
    421 : ('unused', 'unused'),
    422 : ('Unprocessable Entity',
           "The server understands the media type of the\n"
           "request entity, but was unable to process the\n"
           "contained instructions.\n"),
    423 : ('Locked',
           "The requested resource is currently locked.\n"
           "The lock must be released or proper identification\n"
           "given before the method can be applied.\n"),
    424 : ('Failed Dependency',
           "The method could not be performed on the resource\n"
           "because the requested action depended on another\n"
           "action and that other action failed.\n"),

    # Server Error
    # keywords: error
    500 : ('Internal Server Error',
           "The server encountered an internal error or\n"
           "misconfiguration and was unable to complete\n"
           "your request.<P>\n"
           "Please contact the <A HREF='mailto:%(admin)s'>server administrator</A>,\n"
           "and inform them of the time the error occurred,\n"
           "and anything you might have done that may have\n"
           "caused the error.<P>\n"
           "More information about this error may be available\n"
           "in the server error log.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    # keywords: method, uri, error
    501 : ('Method Not Implemented',
           "%(method)s to %(uri)s not supported.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    502 : ('Bad Gateway',
           "The proxy server received an invalid\n"
           "response from an upstream server.<P>\n"
           "<PRE>%(error)s</PRE>\n"),
    503 : ('Service Temporarily Unavailable',
           "The server is temporarily unable to service your\n"
           "request due to maintenance downtime or capacity\n"
           "problems. Please try again later.\n"),
    504 : ('Gateway Time-out',
           "The proxy server did not receive a timely response\n"
           "from the upstream server.\n"),
    505 : ('HTTP Version Not Supported', ''),
    506 : ('Variant Also Negotiates',
           "A variant for the requested resource\n"
           "<PRE>\n%(uri)s\n</PRE>\n"
           "is itself a negotiable resource. "
           "This indicates a configuration error.<P>\n"),
    507 : ('Insufficient Storage',
           "The method could not be performed on the resource\n"
           "because the server is unable to store the\n"
           "representation needed to successfully complete the\n"
           "request.  There is insufficient free space left in\n"
           "your storage allocation.\n"),
    508 : ('unused', 'unused'),
    509 : ('unused', 'unused'),
    510 : ('Not Extended',
           "A mandatory extension policy in the request is not\n"
           "accepted by the server for this resource.\n"),
    }
