import ResourceMetaDataClient

from Ft.Server.FtRpc import Commands


class RawFileClient(ResourceMetaDataClient.ResourceMetaDataClient):
    """Everything in the 4SS repo is a RawFile.  This file is gonna get big..."""


    #######################################
    #XML Interfaces
    #######################################

    def asStylesheet(self):
        """
        Return this object as a non-live compiled stylesheet
        """
        return Commands.RemoteMethodCommand('asStylesheet',
                                            self._path,
                                            ()
                                            ).send(self._connection).results

    def asSchematron(self):
        """
        Return this object as a non-live compiled schematron document
        """
        return Commands.RemoteMethodCommand('asSchematron',
                                            self._path,
                                            ()
                                            ).send(self._connection).results

    ##########################################
    #Mutation Interfaces
    ##########################################

    def setImt(self,imt):
        """
        Sets the Internet Media Type of the raw file resource
        """
        return Commands.RemoteMethodCommand('setImt',
                                            self._path,
                                            (imt,)
                                            ).send(self._connection).results

    def getMetaDataResource(self):
        """
        Get the string meta data of this resource
        """
        return self.fetchResource('.;metadata')

    def getContentResource(self):
        """
        Get the resource the represents the content of this object
        """
        return self




