########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Set/UserData.py,v 1.6 2004/09/23 20:53:32 mbrown Exp $
"""
Implementation of '4ss set userdata' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command sets one custom name-value data pair \
associated with a User resource in a 4Suite repository. If necessary, \
you will be prompted first for credentials and access info to connect \
to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes


def Run(options,args):
    commit = False
    repo = CommandUtil.GetRepository(options,'4ss.set.userdata')
    if repo is not None:
        try:
            name = args['userName']
            user = repo.fetchUserOrGroupByName(name)
            if user is not None:
                if user.isResourceType(ResourceTypes.ResourceType.USER):
                    if args.has_key('value'):
                        user[args['key']] = args['value']
                    else:
                        del user[args['key']]
                    commit = True
                else:
                    #FIXME: use FtServerClientException?
                    sys.stderr.write("%s is a Group, not a User.\n" % name)
                    sys.stderr.flush()

            else:
                #FIXME: use FtServerClientException?
                sys.stderr.write("User %s does not exist.\n" % name)
                sys.stderr.flush()
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('userdata',
                          'Set custom data associated with a User in a repository',
                          'michael age 26',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('userName',
                                                                  "the name of the User",
                                                                  str),
                                       Arguments.RequiredArgument('key',
                                                                  "the key (name part) of a name-value pair",
                                                                  str),
                                       Arguments.OptionalArgument('value',
                                                                  "the value for a name-value pair; no value means delete the key",
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd


