########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Remove/__init__.py,v 1.6 2004/08/20 21:11:02 mbrown Exp $
"""
Implementation of '4ss remove' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command is used to delete a certain type of \
relationship between two objects in a 4Suite repository. \
See the help message for one of the subcommands for details."""


# command modules to register as subcommands
import Member

g_subCommands = [
    Member,
    ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('remove',
                          "Unrelate two resources in a repository (e.g., remove a User from a Group)",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )
    return cmd


