########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/List/Users.py,v 1.7 2004/09/23 20:53:30 mbrown Exp $
"""
Implementation of '4ss list users' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command lists all User resources in a 4Suite \
repository. If necessary, you will be prompted first for \
credentials and access info to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil


def Run(options,args):
    repo = CommandUtil.GetRepository(options, '4ss.list.users')
    if repo is not None:
        try:
            if options.has_key('fullpaths'):
                users = repo.getAllUserPaths()
            else:
                users = repo.getAllUserNames()
            CommandUtil.WritePreamble("Users in the repository:")
            for u in users:
                print u
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('users',
                          'List all Users in a repository',
                          '',
                          __doc__,
                          function = Run,
                          options = Options.Options([Options.Option('f',
                                                                    'fullpaths',
                                                                    'list full paths instead of user names'),
                                     ]),
                          arguments = [
                                       ],
                          fileName = __file__,
                          )
    return cmd
