########################################################################
#
# File Name: 	       Exception.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Exception.py.html
#
"""
Implements the Exception meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import MetaObject
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Exception(MetaObject.MetaObject):

    def __init__(self,db,data):
        MetaObject.MetaObject.__init__(self,db,data,MetaKind.mk_exception)

    def form_result(self,target,inverse = 1):
        from Ft.Ods.MetaData import Structure
        self._4ods_formRelationship('result',Structure.Structure,'exception_result','form',target,inverse)

    def drop_result(self,target,inverse = 1):
        self._4ods_dropRelationship('result','exception_result','drop',target,inverse)


    def add_operations(self,target,inverse = 1):
        from Ft.Ods.MetaData import Operation
        self._4ods_addRelationship('operations',Operation.Operation,'exceptions','add',target,inverse)
    form_operations = add_operations


    def remove_operations(self,target,inverse = 1):
        self._4ods_removeRelationship('operations','exceptions','remove',target,inverse)
    drop_operations= remove_operations

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getOdl(self,indent = ''):
        st = indent + 'exception %s {\n' % self.name
        if self.result:
            for m in self.result.fields:
                st = st + m._4ods_getOdl(indent + '  ') + ';\n'
        st = st + indent + '}'
        return st


    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        found.append(self)
        for f in self.result.fields:
            f._4ods_getGeneratedMetaClasses(found,checked)
        return found



    _tupleNames = (('result',),('operations',))

    _tupleDefinitions = {'result':{td.TYPE:Constants.Types.ROBJECT,
                                   td.READONLY:1,
                                   td.RELATIONSHIP:1,
                                   },
                         'operations':{td.TYPE:Constants.Types.SET_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         }

    _localExtents = ()
