########################################################################
#
# File Name: 	       Dictionary.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Dictionary.py.html
#
"""
Implements the Dictionary meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import Collection
from Ft.Ods.MetaData import CollectionKind, MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.PersistentObject import TupleDefinitions
td = TupleDefinitions

class Dictionary(Collection.Collection):

    def __init__(self,db,data):
        Collection.Collection.__init__(self,
                                       db,
                                       data,
                                       CollectionKind.ck_dictionary)

    def form_key_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Type
        self._4ods_formRelationship('key_type',Type.Type,'dictionaries','add',target,inverse)

    def drop_key_type(self,target,inverse = 1):
        self._4ods_dropRelationship('key_type','dictionaries','remove',target,inverse)


    def _4ods_getOdmgType(self):
        return Constants.Types.DICTIONARY_COLLECTION


    def _4ods_getOdl(self,indent):
        return indent + "dictionary <%s,%s>" % (self.key_type.absolute_name(),self.subtype.absolute_name())

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        self.subtype._4ods_getGeneratedMetaClasses(found,checked)
        self.key_type._4ods_getGeneratedMetaClasses(found,checked)



    _tupleNames =  (('key_type',),)

    _tupleDefinitions = {'key_type':{td.TYPE:Constants.Types.ROBJECT,
                                     td.READONLY:1,
                                     td.RELATIONSHIP:1,
                                     }
                         }

    _localExtents = ()
