import sys
from distutils.command import bdist

class BDist(bdist.bdist):

    command_name = 'bdist'
    
    format_command = bdist.bdist.format_command.copy()
    format_command['inno'] = ('bdist_inno', 'Windows InnoSetup installer')

    def finalize_options(self):
        if self.formats is None:
            # Choose the default format for this platform
            if sys.platform == 'linux2':
                self.formats = ['rpm']
            elif sys.platform == 'win32':
                self.formats = ['inno']

        bdist.bdist.finalize_options(self)
        return
