<?
function CreateImage($size, $source, $dest, $border = 0)
{
  $sourcedate = 0;
  $destdate = 0;
  global $convert;
  if (file_exists($dest)) {
    clearstatcache();
    $sourceinfo = stat($source);
    $destinfo = stat($dest);
    $sourcedate = $sourceinfo[10];
    $destdate = $destinfo[10];
  }
  if (!file_exists("$dest") or ($sourcedate > $destdate)) {
    global $ImageTool;
    $imgsize = GetImageSize($source);
    $width = $imgsize[0];
    $height = $imgsize[1];
    
    /*  $new_width = $size; */
    /*  $new_height = ceil($size * $height / $width); */
    
    if ($width > $height) {
      $new_width = $size;
      $new_height = ceil($size * $height / $width);
    }
    else {
      $new_height = $size;
      $new_width = ceil($size * $width / $height);
    }
    
    if ($ImageTool == "gd") {
      $im = ImageCreateFromJPEG($source); 
      $new_im = ImageCreate($new_width,$new_height);
      
      ImageCopyResized($new_im, $im, 0, 0, 0, 0, $new_width, $new_height,
		       ImageSX($im), ImageSY($im));
      ImageJPEG($new_im, $dest, 75);
    }
    else if ($ImageTool == "im") {
      system("$convert -quality 80 -antialias -sample $new_width" . "x" 
	     . "$new_height \"$source\" \"$dest\" 2>&1");
    }
  }
}

/**
 * Rotates image $source $degrees and saves it to $dest.
 * Only implemented for ImageMagick yet.
 */
function rotateImage($source, $dest, $degree)
{
  global $ImageTool;
  
  /* if file already exits, check if source is newer. If true rotate. */
  if (file_exists($dest)) {
    clearstatcache();
    $sourceinfo = stat($source);
    $destinfo = stat($dest);
    $sourcedate = $sourceinfo[10];
    $destdate = $destinfo[10];
    if ($sourcedate <= $destdate) {
      return;
    }
  }
  
  if ($ImageTool == "im") {
    global $convert;
    system("$convert -rotate $degree \"$source\" \"$dest\" 2>&1");
  }
}

/**
 * Make sure only valid degrees are allowed.
 */
function validate($degree)
{
  if ($degree != 90 && $degree != 180 && $degree != 270) {
    return 0;
  }
  else {
    return $degree;
  }
}

/**
 * Serializes array to file.
 */
function writeArray($array, $file)
{
  $fd = fopen($file, "w");
  if ($fd) {
    fwrite($fd, serialize($array));
    fclose($fd);
  }
}

/**
 * Reads array from file.
 */
function readArray($file)
{
  if (!file_exists($file) || !($fd = fopen($file, "r"))) {
    return array(0 => 0, 90 => 0, 180 => 0, 270 => 0);
  }
  $buffer = fread($fd, filesize($file));
  fclose($fd);
  return unserialize($buffer);
}

/**
 * Get preferred display angle for a file.
 */
function getPreferredAngle($file)
{
  global $dynbase, $album;
  $file = "$dynbase/$album/$file" . "_angle.txt";

  if (!file_exists($file)) {
    return 0;
  }
  $prefs = readArray($file);
  return maxKey($prefs);
}

/**
 * Returns the key which holds the greatest value.
 */
function maxKey($array)
{
  $key = 0;
  while (list($k, $v) = each($array)) {
    if ($v > $value) {
      $value = $v;
      $key = $k;
    }
  }
  return $key;
}

/**
 * Saves the preferred display angles of picture.
 */
function updatedPreferredAngle($degree, $file)
{
  global $dynbase, $album;
  $file = "$dynbase/$album/$file" . "_angle.txt";

  $degree = validate($degree);
  $prefs = readArray($file);
  
  while (list($key, $value) = each($prefs)) {
    if ($key == $degree) {
      $prefs[$key]++;
      break;
    }
  }
  writeArray($prefs, $file);
}
  
  
/**
 * Prints navigation bar at top and displays additional titles of pictures.
 */
function NavBar($mode,$path,$start)
{
  $endpoint = basename($path);
  global $pix_base;
  global $realbase;
  global $dispsize;
  global $sitehome;
  global $display_cols;
  if ($sitehome != '') {
    print "<A HREF=\"$sitehome\">Home</a> -> \n";
  }
  print "<A HREF=" . dirname($SCRIPT_NAME) 
    . "?dispsize=$dispsize>Albums</a>\n";
  $doo = split("/",$path);
  $prepath = '';
  while (list($foo,$filename) = each($doo)) {
    if ($prepath) {
      $fullname = $prepath . "/" . $filename;
    }
    else {
      $fullname = $filename;
    }
    if ($filename == $endpoint) { 
      print " -> <b>$filename</b>\n";
    }
    else {
      print " -> <A HREF=?mode=album&album=" . urlencode($fullname) 
	. "&dispsize=$dispsize&start=$start>$filename</a>\n";
    }
    $prepath = $fullname;
  }
  $fn = $pix_base . "/" . $path;
  $infofile = "";
  if (is_dir($fn)) {
    $infofile = $pix_base . "/" . $path . "/info.txt";
  }
  else {
    $infofile = $pix_base . "/" . preg_replace('/(.*)\.jpg/i', '\1.txt',
					       $path);
  }
  if (file_exists($infofile)) {
    list($title, $desc) = ParseInfoFile($infofile, $name);
    print "  $title</td></tr>\n<tr bgcolor=white>" 
      . "<td colspan=$display_cols>" . $desc . "</td>\n";
  }
}

function PrintAlbumName($pix_base, $name)
{
  $infofile = $pix_base . "/" . $name . "/info.txt";
  $title = "";
  if (file_exists($infofile)) {
    list($title, $desc) = ParseInfoFile($infofile, $name);
    if ($title == "\n") {
      $title = $name;
    }
  }
  else {
    $title = $name;
  }
  print "<A HREF=?mode=album&album=" . urlencode($name) .
    "&dispsize=$dispsize>";
  print "<b>$title</b>";
  print "</a><br>\n";
}
 
/* Info files have two lines - one is the "title" and the second is a longer
   "description". */
function ParseInfoFile($filename, $basename)
{
  return file($filename);
}

function checkDir($pathname)
{
  $darray = split("/",$pathname);
  for ($x = 1; $x < sizeof($darray); $x++) {
    $checkdir = '';
    for($y = 1; $y <= $x; $y++) {
      $checkdir .= "/" . $darray[$y];
    }
    if (!file_exists($checkdir)) {
      mkdir($checkdir, 0755);
    }
  }
}
?>
