// soundeditor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// DataEditor subclass for handling modifications of Sound objects.

#ifndef SOUNDEDITOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define SOUNDEDITOR_H

#include "editor.h"

class Controller;
class Data;
class Sound;

class SoundEditor : public DataEditor {
	typedef DataEditor Super;
public:
	// file methods
	static Controller* new_File(Controller *);
	redefined Status newFile();
	// modify methods
	redefined Status changeLength();
	redefined Status interpolate();
	redefined Status insertSpace();
	Status removeDC_Component();
	redefined Status lowPassFilter();
	Status resonFilter();
	Status combFilter();
	Status ellipticalFilter();
	Status firFilter();
	Status lpcFilter();
 	// converter methods
	Status record();
	Status play();
	Status stop();
	Status configureConverter();
	// synthesis methods
	Status resynthesizeFromLPC();
	Status resynthesizeFromPvoc();
	// analysis methods
	Status rescanForPeak();
	redefined Status rescale();
	Status changeFormat();
	Status pitchTrackAnalysis();
	Status FFTAnalysis();
	Status PVocAnalysis();
	Status LPCAnalysis();
	Status LPCAndPitchTrackAnalysis();
	Status findSilence();
	redefined Status setDataOptions();
	redefined Status setRawFileOptions();
protected:
	SoundEditor(Controller *c) : DataEditor(c) {}
	SoundEditor(Controller *c, const Data *d) : DataEditor(c, d) {}
	Sound *soundModel() { return (Sound *) model(); }
	redefined boolean keyCommand(unsigned long);
	redefined Modifier *getFileSaver(const char *dir, Data *d, const char *filename=nil);
public:
	redefined const MenuBarInfo *menuBarInfo() const;
	static DataEditor* new_DataEditor1(Controller *);
	static DataEditor* new_DataEditor2(Controller *, const Data *);
private:
	friend class DataEditor;	
	friend class Controller;
	redefined Data *newModel();
};

#endif
