// scroller.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// My adaptation of the InterViews Scroller class.

#ifndef scroller_h
#ifdef __GNUG__
#pragma interface
#endif
#define scroller_h

#include <InterViews/scene.h>
#include <InterViews/adjuster.h>

class XEnlarger : public Enlarger {
public:
    XEnlarger(Interactor*);
    XEnlarger(const char*, Interactor*);
protected:
    void AdjustView(Event&);
private:
    void Init();
};

class XReducer : public Reducer {
public:
    XReducer(Interactor*);
    XReducer(const char*, Interactor*);
protected:
    void AdjustView(Event&);
private:
    void Init();
};

class YEnlarger : public Enlarger {
public:
    YEnlarger(Interactor*);
    YEnlarger(const char*, Interactor*);
protected:
    void AdjustView(Event&);
private:
    void Init();
};

class YReducer : public Reducer {
public:
    YReducer(Interactor*);
    YReducer(const char*, Interactor*);
protected:
    void AdjustView(Event&);
private:
    void Init();
};

class ScrollerBar : public Interactor {
public:
    ScrollerBar(Interactor*, int h = 20);
    ScrollerBar(const char*, Interactor*, int h = 20);
    virtual ~ScrollerBar();

    virtual void Draw();
    virtual void Handle(Event&);
    virtual void Update();
    virtual void Reshape(Shape&);
    virtual void Resize();
protected:
    virtual void Reconfig();
    virtual void Redraw(Coord, Coord, Coord, Coord);

    boolean Inside(Event&);		// true if inside slider knob
    void Slide(Event&);			// rubberband rect while mousing
    void Jump(Event&);			// for click outside knob
	void makeAdjust();
    boolean syncScroll;
private:
    Interactor* interactor;
    Perspective* view;
    Perspective* shown;
    Coord left, bottom, right, top;
    Coord prevl, prevb, prevr, prevt;	// for smart update
    Coord llim, blim, rlim, tlim;	// sliding limits
    Coord origx, origy;

    void Init(Interactor*, int);
    Coord ViewX(Coord);
    Coord ViewY(Coord);
    Coord ScrollerBarX(Coord);
    Coord ScrollerBarY(Coord);
    void CalcLimits(Event&);		// calculate sliding limits
    void SizeKnob();			// calculate size of slider knob
    void Move(Coord dx, Coord dy);	// move view to reflect slider position
    void Constrain(Event&);
};

class HorizontalViewScroller : public MonoScene {
public:
    HorizontalViewScroller(Interactor*, int height = 20);
    HorizontalViewScroller(const char*, Interactor*, int height = 20);
    HorizontalViewScroller(Interactor*, int height, Painter*);
	
	redefined void Update();
private:
    Interactor* scrollbar;

    void Init(Interactor*, int);
};

class VerticalViewScroller : public MonoScene {
public:
    VerticalViewScroller(Interactor*, int width = 20);
    VerticalViewScroller(const char*, Interactor*, int width = 20);
    VerticalViewScroller(Interactor*, int width, Painter*);
	
	redefined void Update();
private:
    Interactor* scrollbar;

    void Init(Interactor*, int);
};

class ViewScaler : public MonoScene {
public:
    ViewScaler(Interactor*, int size = 0);
    ViewScaler(const char*, Interactor*, int size = 0);
    ViewScaler(Interactor*, int size, Painter*);
protected:
	int size;
    virtual void Reconfig();
private:
    Interactor* adjusters;

    void Init(Interactor*, int);
};

#endif
