// formantsynth.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FormantSynth combines a time-varying All-Pass filter with a Buzz object
// (harmonically-limited pulse generator) and a RandomNoise object to allow
// mixed-excitation resynthesis of Linear Predictive Coding analysis files.

#ifndef FORMANTSYNTH_H
#ifdef __GNUG__
#pragma interface
#endif
#define FORMANTSYNTH_H

#include "lpcfilter.h"
#include "randomnoise.h"
#include "synthfunction.h"

class Data;
class LPCData;
class ResonFilter;

class FormantSynthesizer : private LPC_Filter, public Buzz {
	friend class FormantSynthRequester;
public:
	FormantSynthesizer(Data* output, Data *lpdata, double, int, double amp=1.0);
	FormantSynthesizer(Data* output, Data *lpdata);
	redefined ~FormantSynthesizer();
	redefined void restoreState();
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined Status doConfigure(Controller *);
	redefined double doSynthesis();
	void setTransposeFactor(double factor) { transposeFactor = factor; }
	void setUnvoicedOnly(boolean flag) { unvoicedOnly = flag; }
	double voiced() { return Buzz::doSynthesis(); }
	double unvoiced() { return noise(); }
private:
	RandomNoise noise;
	ResonFilter *pResonFilter;
	double gain;
	double voicedFactor;
	double hiThreshold, lowThreshold;
	double warpFactor;
	ChoiceValue interpMode;
	double transposeFactor;
	double resonCF, resonBW;
	double gainThresh;
	boolean unvoicedOnly;
	double srOverTwo;			// cached for optimization
private:
	static double _savedGain;
	static double _savedVoicedFactor;
	static double _savedHiThreshold, _savedLowThreshold;
	static double _savedWarpFactor, _savedTransposeFactor;
	static double _savedResonCF, _savedResonBW;
	static double _savedGainThresh;
	static ChoiceValue _savedInterpMode;
};

#endif
