// application.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Application is the single-instance class representing the running program.
// Most of its members are static and globally available, and are used by
// methods of all classes to communicate with the user.  The Application keeps
// track of the currently active Controller instance via an update method
// called by the Controller that has most recently received an event.

#ifndef APPLICATION_H
#ifdef __GNUG__
#pragma interface
#endif
#define APPLICATION_H

#include "localdefs.h"

class World;
class GlobalResourceList;
class Controller;
class Request;

class Application {
public:
	Application(int argc, char** argv, struct OptionDesc[], struct PropertyData[]);
	~Application();
	int Run();
	static void inform(const char*, boolean wait=0);
	static void inform();
	static void busy(boolean);
	static void error(const char* msg1, const char* msg2=nil);
	static void alert(const char* m1, const char* m2=nil,
		const char* m3=nil, const char* ="  ok  ");
	static boolean confirm(const char* m1, const char* m2=nil,
		const char* m3=nil, Response r=Yes, const char* ="confirm",
		const char* ="cancel");
	static Response choice(const char* m1, const char* m2=nil,
		const char* m3=nil, Response r=Yes, const char* =" yes ",
		const char* ="  no  ", const char* ="cancel");
	static int handle(Request &);
	static void die(const char*);
	static void error_handler(const char*);
	static void setGlobalResource(const char* resName, const char* resValue);
	static const char* getGlobalResource(const char* resName);
	static double getGlobalResourceValue(const char* resName);
	static boolean globalResourceIsTrue(const char* resName);
	static boolean isLittleEndian();
protected:
	int extractSkipAndDurationArgs(char**, int, int, double&, double&);
	void createStatusBar(World *world);
	static void setGlobalController(Controller* c);
	static boolean isGlobalController(Controller* c);
private:
	friend class Controller;
	static int global_errno;
	static Controller* global_controller;
	static int worldVisible;
	static World* world;
	static class StatusBar* statusBar;
	static GlobalResourceList* resourceList;
};

#endif

