// $Id: DescendantAxisExpr.java,v 1.1 2002/04/25 18:05:58 bill Exp $

package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

/**
 * XPath expression (component) representing descendant axis
 */
class DescendantAxisExpr extends AxisExpr 
{

    public NodeIterator eval(Node node, 
                             ExprContext context) throws XSLException 
    {
        NodeIterator iter = new DescendantsOrSelfNodeIterator(node);
        iter.next();
        return iter;
    }

    int getOptimizeFlags() 
    {
        return STAYS_IN_SUBTREE;
    }
}
