/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management.monitor;

import javax.management.ObjectName;

/**
 * Interface MonitorMBean. It is the management interface of MonitoringMBeans
 *
 * @see Monitor
 * @author <a href="mailto:tibu@users.sourceforge.net">Carlos Quiroz</a>
 * @version $Revision: 1.3 $
 */
public interface MonitorMBean
{
  public void addObservedObject(ObjectName object);
  
  public boolean containsObservedObject(ObjectName object);
  
  public ObjectName [] getObservedObjects();
  
  public void removeObservedObject(ObjectName object);
  
  public void start();

  public void stop();

  /**
   * @deprecated
   */
  public ObjectName getObservedObject();
  
  /**
   * @deprecated
   */
  public void setObservedObject(ObjectName object);

  public String getObservedAttribute();

  public void setObservedAttribute(String attribute);

  public long getGranularityPeriod();

  public void setGranularityPeriod(long period) throws java.lang.IllegalArgumentException;

  public boolean isActive();
}


