/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_STATUS_H__
#define __SINGIT_STATUS_H__

#include <gtk/gtkobject.h>

#include <pthread.h>

#include "singit/config_gen.h"
#include "singit/singleton.h"
#include "singit/framerate_counter.h"
#include "singit/song.h"
#include "singit/sound_precalcs.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_SINGIT_STATUS            (singit_status_get_type ())
#define SINGIT_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_STATUS, SingitStatus))
#define SINGIT_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_STATUS, SingitStatus))
#define IS_SINGIT_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_STATUS))
#define IS_SINGIT_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_STATUS))

typedef struct _SingitStatus       SingitStatus;
typedef struct _SingitStatusClass  SingitStatusClass;

struct _SingitStatus {

	SingitSingleton          singleton;

	SingitConfigGen         *config;

	SingitSong              *song;
	GList                   *next_lyric_line;

	pthread_t                display_thread;
	pthread_t                check_thread;

	pthread_mutex_t          config_rw_mutex;
	pthread_mutex_t          lyrics_rw_mutex;

	gboolean                 kill_threads;
	gboolean                 initialize_plugins;

	gboolean                 config_update;
	gboolean                 playing;
	gboolean                 song_changed;
	gboolean                 text_update;

	SingitSoundPrecalcs     *singit_sound_precalcs;
	SingitFramerateCounter  *singit_framerate_counter;

	gint                     old_time;
};

struct _SingitStatusClass {

	SingitSingletonClass     parent_class;
};

GtkType            singit_status_get_type (void);

// The function returns the singleton and if none exists creates it
SingitSingleton*   singit_status_ref(void);
// The function dereeferences the singleton and frees it,
// if the reference count drops below 1
void               singit_status_unref(SingitSingleton** single);

// The "unsecure" reference function.
// It just returns the singleton object
SingitSingleton*   singit_status_noref(void);

#define STATUS \
	((singit_status_noref() == NULL) ? NULL : SINGIT_STATUS(singit_status_noref()))

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif  // __SINGIT_STATUS_H__
