/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONTROL_H__
#define __SINGIT_CONTROL_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

gint singit_remote_get_xmms_session(gint session);

gint singit_remote_get_version(gint session);
void singit_remote_quit(gint session);

void singit_remote_show_prefs_dlg(gint session);
void singit_remote_show_about_dlg(gint session);
void singit_remote_show_about_keys_dlg(gint session);
void singit_remote_show_editor_dlg(gint session);
void singit_remote_show_tag_manager_dlg(gint session);

gboolean singit_remote_cfg_toggle_yz(gint session);
gboolean singit_remote_cfg_hide_if_not_found(gint session);
gboolean singit_remote_cfg_show_empty(gint session);
gboolean singit_remote_cfg_auto_resize(gint session);
gboolean singit_remote_cfg_debug_enabled(gint session);
gboolean singit_remote_cfg_show_time_indicator(gint session);
gboolean singit_remote_cfg_guess_synced_lyrics(gint session);
gboolean singit_remote_cfg_show_jumping_ball(gint session);
gboolean singit_remote_cfg_find_optimal_font(gint session);

gchar* singit_remote_cfg_lyric_font_name(gint session);
gchar* singit_remote_cfg_color(gint session, gint type);

gboolean singit_remote_cfg_framerate_limit_enabled(gint session);
gint     singit_remote_cfg_framerate_limit(gint session);


// *  The following macros help to get config values
// *  You have to define the following values to use them
// *
// * #define CTRL_SESSION 		sessionid
// * #define CTRL_CFG_DATA	cfg_data

#define REMOTE_CFG(cfg_func) \
do { CTRL_CFG_DATA->cfg_func = singit_remote_cfg_##cfg_func(CTRL_SESSION); } while (0)

#define REMOTE_CFG_ARG(cfg_func,args) \
do { CTRL_CFG_DATA->cfg_func = singit_remote_cfg_##cfg_func(CTRL_SESSION, args); } while (0)

#define REMOTE_CFG_V(cfg_func,val) \
do { CTRL_CFG_DATA->val = singit_remote_cfg_##cfg_func(CTRL_SESSION); } while (0)

#define REMOTE_CFG_ARG_V(cfg_func,args,val) \
do { CTRL_CFG_DATA->val = singit_remote_cfg_##cfg_func(CTRL_SESSION, args); } while (0)


#ifdef __cplusplus
};
#endif // __cplusplus

#endif // __SINGIT_CONTROL_H__
