
#include "G-Force_Proj.h"

#include "G-Force.h"

#include "XFloatList.h"

#define __defaultTTFormat 	"#ARTIST# - #TITLE#"
#define __defaultFont 		""

#include <stdio.h>
#define __drawText( x, y, str )		fprintf(stderr,str->getCStr());


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>
#include <stdlib.h>

#include "RectUtils.h"
#include "CEgFileSpec.h"
#include "EgOSUtils.h"
#include "Expression.h"
#include "Hashtable.h"
#include "ParticleGroup.h"

// #include "displayer_sdl_lyrics.h"

static PluginInfo info = {

	PLUGIN_ID,
	PLUGIN_AUTHOR,
	_PLUGIN_NAME,
	_PLUGIN_VERS,
	LONG_VERS_STR,
	MAIN_CONFIGS_FOLDER,
	PREFS_NAME,
	PREFS_COMPAT_VERSION
};

GForce::GForce( long inHostVers, void* inRefCon ) :
	PluginGlue( inHostVers, inRefCon, info ),
	mPal1( &mT, &mIntensityParam ),
	mPal2( &mT, &mIntensityParam ),
	mWave1( &mT ),
	mWave2( &mT ) {

// Do initting ...
	mNextPaletteUpdate	=
	mNextShapeChange	= mT + 10;
	mNextFieldChange	= mT + 10;
	mNextColorChange	= mT + 10;
	mLastSongStart		= mT - 10000;
	mShapeSlideShow		=
	mColorSlideShow		=
	mFieldSlideShow		= true;

	Init();

	CacheFolder( "ColorMaps", mColorMaps, &mColorPlayList, 3 * mCacheDepth );
	CacheFolder( "Particles", mParticles, &mParticlePlayList, 3 * mCacheDepth );
	CacheFolder( "DeltaFields", mDeltaFields, &mFieldPlayList, 3 * mCacheDepth );
	CacheFolder( "WaveShapes", mWaveShapes, &mShapePlayList, 3 * mCacheDepth );

	printf("%li / %li / %li / %li / %li\n",
		mColorPlayList.Count(), mParticlePlayList.Count(),
		mFieldPlayList.Count(), mShapePlayList.Count(), mCacheDepth);

	// Show the welcome msg for a pref rewrite...
	Println( "SDL Displayer feat. G-Force 1.1.6 codebase" );
	Println( "Press '?' for help" );

	// Catch any bad values for mNumSampleBins
	if ( mNum_S_Steps < 1 || mNum_S_Steps > 10000 )
		mNum_S_Steps = 320;

	// Alloc/setup the data we'll have our virtual machines accessing...
	SetNumSampleBins( mNum_S_Steps );

	// Setup waveshape members
	mWave1.SetMagFcn( (ExprUserFcn**) &mSampleFcn );
	mWave2.SetMagFcn( (ExprUserFcn**) &mSampleFcn );

	// Init particle stuff
	mDict.AddVar( "T", &mT );
	mDict.AddVar( "LAST_PARTICLE_START", &mLastParticleStart );
	mDict.AddVar( "NUM_PARTICLES", &mNumRunningParticles );
	mNumRunningParticles = 0;
	mNextParticleCheck = mT + 1;
	mParticleProbabilityFcn.Compile( mParticleProbability, mDict );
	mParticleDurationFcn.Compile( mParticleDuration, mDict );
	mShapeInterval.Compile( mShapeIntervalStr, mDict );
	mColorInterval.Compile( mColorIntervalStr, mDict );
	mFieldInterval.Compile( mFieldIntervalStr, mDict );

	// Track Text stuff
//	mDict.AddVar( "LAST_SONG_START", &mLastSongStart );
//	mTrackTextStartFcn.Compile( mTrackTextStartStr, mDict );

	// Transition bookkeeping
	mColorTransTime		= -1;
	mShapeTransTime		= -1;
	mGF_Palette		= NULL;
	mWave			= NULL;

	mField		= &mField1;
	mNextField	= &mField2;
}

GForce::~GForce()
{
}

#define __assertPref( field,arg )								if ( ! inPrefs.PrefExists( field ) )		\
	inPrefs.SetPref( field, arg )

#define __compilePref( field, expr ) \
do { \
	inPrefs.GetPref( field, str );	\
	expr.Compile( str, mDict ); \
} while (0)

void GForce::LoadPrefs( Prefs& inPrefs ) {

	PluginGlue::LoadPrefs( inPrefs );

	mTrackTextDur = mPrefs.GetPref( MCC4_TO_INT("TDur") );

	UtilStr str;

	mTransitionLo		= mPrefs.GetPref( MCC4_TO_INT("TrLo") );
	mTransitionHi		= mPrefs.GetPref( MCC4_TO_INT("TrHi") );
	mHandleKeys		= mPrefs.GetPref( MCC4_TO_INT("Kybd") );
	mNum_S_Steps		= mPrefs.GetPref( MCC4_TO_INT("Stps") );
	mParticlesOn		= mPrefs.GetPref( MCC4_TO_INT("P_On") );
	mNewConfigNotify	= mPrefs.GetPref( MCC4_TO_INT("ShwT") );

	mPrefs.GetPref( MCC4_TO_INT("WInt"), mShapeIntervalStr );
	mPrefs.GetPref( MCC4_TO_INT("DInt"), mFieldIntervalStr );
	mPrefs.GetPref( MCC4_TO_INT("CInt"), mColorIntervalStr );
	mPrefs.GetPref( MCC4_TO_INT("PDur"), mParticleDuration );
	mPrefs.GetPref( MCC4_TO_INT("PPrb"), mParticleProbability );
	mPrefs.GetPref( MCC4_TO_INT("KMap"), mKeyMap );

	if ( mFullscreenDepth < 16 )
		mFullscreenDepth = 16;
}

void GForce::SavePrefs( Prefs& inPrefs ) {

	PluginGlue::SavePrefs( inPrefs );

	__assertPref( MCC4_TO_INT("TDur"), 7 );
	__assertPref( MCC4_TO_INT("Slde"), "15 + rnd( 10 )" );
	__assertPref( MCC4_TO_INT("MDur"), "5 + rnd( 17 )" );
	__assertPref( MCC4_TO_INT("MTrs"), "i^1.6" );

	__assertPref( MCC4_TO_INT("TrLo"), 4 );
	__assertPref( MCC4_TO_INT("TrHi"), 18 );
	__assertPref( MCC4_TO_INT("Kybd"), 1 );
	__assertPref( MCC4_TO_INT("Stps"), 200 );
	__assertPref( MCC4_TO_INT("P_On"), true );
	__assertPref( MCC4_TO_INT("ShwT"), false );
	__assertPref( MCC4_TO_INT("WInt"), "10 + rnd( 15 )" );
	__assertPref( MCC4_TO_INT("DInt"), "18 + rnd( 15 )" );
	__assertPref( MCC4_TO_INT("CInt"), "10 + rnd( 15 )");
	__assertPref( MCC4_TO_INT("PDur"), "8 + rnd( 15 )" );
	__assertPref( MCC4_TO_INT("PPrb"), ".09/((NUM_PARTICLES+1)^1.66)" );
	__assertPref( MCC4_TO_INT("KMap"), "TLRY`SNGFZXCQWE,.M[]{}P******!@#$%^&*()1234567890" );
}

void GForce::SetNumSampleBins( long inNumBins )
{
	float k;

	if ( inNumBins > 0 && inNumBins < 10000 ) {
		mSampleFcn = (ExprUserFcn*) mSamplesBuf.Dim( sizeof( float ) * inNumBins + sizeof( ExprUserFcn ) + 32 );
		mNum_S_Steps = inNumBins;
		mSampleFcn -> mNumFcnBins = inNumBins;

		// A fast lookup table for a sine wave
		mSine = (float*) mSineBuf.Dim( sizeof( float ) * inNumBins );
		k =  6.2831853071795 / ( (float) inNumBins );

		for ( int i = 0; i < inNumBins; i++ ) {
			mSampleFcn -> mFcn[ i ] = 0;
			mSine[ i ] = sin(  k * ( (float) i ) );
		}
	}
}

void GForce::ShowHelp()
{
	Println( "SDL Displayer feat. G-Force 1.1.6 codebase" );
	Println( "" );
	Println( "Alt  + Enter  - Toggle fullsceen" );
	Println( "Esc           - Quit fullscreen / plugin" );
	Println( "" );
	Println( "y/z           - Previous song" );
	Println( "x             - Play song" );
	Println( "c             - Pause song" );
	Println( "v             - Stop song" );
	Println( "b             - Next song" );
	Println( "" );
//	Println( "t             - Display track title" );
	Println( "s             - List configs" );
	Println( "f             - Frame Rate" );
	Println( "" );
	Println( "       j k l  - Prev/Next/Hold DeltaField" );
	Println( "Ctrl + j k l  - Prev/Next/Hold ColorMap" );
	Println( "Alt  + j k l  - Prev/Next/Hold WaveShape" );
	Println( "" );
}

bool GForce::HandleKey( long inChar )
{
	bool handled = true;
//	int n;

	// See if this keystroke is to be ignored
	if ( ! mHandleKeys )
		return false;

	if ( inChar >= 'a' && inChar <= 'z' )
		inChar = 'A' + ( inChar - 'a' );

	if ( inChar == 27 ) // ESC key
		SetFullscreen( false );
	else if ( inChar == '/' || inChar == '?' )
		ShowHelp();
	else if ( inChar >= ' ' && inChar < 129 ) {

		inChar = mKeyMap.FindNextInstanceOf( 0, inChar );

		handled = HandleCommand(inChar);
	}
	else
		handled = false;

	return handled;
}

bool GForce::HandleCommand( long command )
{
	bool handled = true;
	int n;

	switch ( command ) {

	case cGetConfigInfo:
	{
		mConsoleLines.RemoveAll();
		Print( "WaveShape:  " );
		Println( &mWaveShapeName );
		Print( "ColorMap:   " );
		Println( &mColorMapName );
		Print( "DeltaField: " );
		Println( mField -> GetName() );
		Print( "Particles:  " );
		ParticleGroup* particle = (ParticleGroup*) mRunningParticlePool.GetHead();

		if ( particle ) {
			while ( particle ) {
				Print( &particle -> mTitle );
				particle = (ParticleGroup*) particle -> GetNext();
				if ( particle )
					Print( ", " );
			}
			Println( "" );
		}
		else { Println( "<(none)>" ); }
		break;
	}
	case cToggleParticles:
		mParticlesOn = ! mParticlesOn;
		if ( mParticlesOn )
			Println( "Particles ON" );
		else
			Println( "Particles OFF" );
		break;
	case cSpawnNewParticle:
		SpawnNewParticle();
		break;
	case cToggleFullsceen:
//		xpce_ToggleFullscreen();
		break;
	case cDecNumSSteps:
	case cIncNumSSteps:
		if ( command == cDecNumSSteps )
			n = - 4;
		else
			n = + 4;
		SetNumSampleBins( mNum_S_Steps + n );
		mTemp.Assign( "Number s steps: " );
		mTemp.Append( mNum_S_Steps );
		Println( &mTemp );
		break;
	case cToggleConfigName:
		mNewConfigNotify = ! mNewConfigNotify;
		if ( mNewConfigNotify )
			Println( "Show names ON" );
		else
			Println( "Show names OFF" );
		break;
	case cPrevDeltaField:
	case cNextDeltaField:
		n = mFieldPlayList.FindIndexOf( mCurFieldNum );
		if ( command == cPrevDeltaField )
			n = n + mFieldPlayList.Count() - 2;

		loadDeltaField( mFieldPlayList.Fetch( 1 + n % mFieldPlayList.Count() ) );

		// If the pref says so, display that we're loading a new config
		if ( mNewConfigNotify ) {
			Print( "Loading DeltaField: " );
			Println( mField -> GetName() );
		}

		// Turn field slide show off when we change deltafields manually
		if ( ! mFieldSlideShow )
			break;
	case cToggleFieldShow:
		mFieldSlideShow = ! mFieldSlideShow;
		mNextFieldChange = mT;
		if ( mFieldSlideShow ) {
			Println( "DeltaField slideshow ON" );
			mFieldPlayList.Randomize(); }
		else
			Println( "DeltaField slideshow OFF" );
		break;
	case cStartSlideshowAll:
		mFieldSlideShow = true;		mNextFieldChange = mT;
		mColorSlideShow = true;		mNextColorChange = mT;
		mShapeSlideShow = true;		mNextShapeChange = mT;
		Println( "All slideshows ON" );
		break;
	case cStopSlideshowAll:
		mFieldSlideShow = false;
		mColorSlideShow = false;
		mShapeSlideShow = false;
		Println( "All slideshows OFF" );
		break;
	case cPrevColorMap:
	case cNextColorMap:
		n = mColorPlayList.FindIndexOf( mCurColorMapNum );
		if ( command == cPrevColorMap )
			n = n + mColorPlayList.Count() - 2;

		loadColorMap( mColorPlayList.Fetch( 1 + n % mColorPlayList.Count() ), false );

		// Turn slide show off when we change colormaps manually
		if ( ! mColorSlideShow )
			break;
	case cToggleColorShow:
		mColorSlideShow = ! mColorSlideShow;
		mNextColorChange = mT;
		if ( mColorSlideShow ) {
			Println( "ColorMap slideshow ON" );
			mColorPlayList.Randomize(); }
		else
			Println( "ColorMap slideshow OFF" );
		break;
	case cPrevWaveShape:
	case cNextWaveShape:
		n = mShapePlayList.FindIndexOf( mCurShapeNum );
		if ( command == cPrevWaveShape )
			n = n + mShapePlayList.Count() - 2;

		loadWaveShape( mShapePlayList.Fetch( 1 + n % mShapePlayList.Count() ), false );

		// Turn slide show off when we change shapes manually
		if ( ! mShapeSlideShow )
			break;
	case cToggleShapeShow:
		mShapeSlideShow = ! mShapeSlideShow;
		mNextShapeChange = mT;
		if ( mShapeSlideShow ) {
			Println( "WaveShape slideshow ON" );
			mShapePlayList.Randomize(); }
		else
			Println( "WaveShape slideshow OFF" );
		break;
	case cSetPreset0:	StoreConfigState( MCC4_TO_INT("SET0") );	break;
	case cSetPreset1:	StoreConfigState( MCC4_TO_INT("SET1") );	break;
	case cSetPreset2:	StoreConfigState( MCC4_TO_INT("SET2") );	break;
	case cSetPreset3:	StoreConfigState( MCC4_TO_INT("SET3") );	break;
	case cSetPreset4:	StoreConfigState( MCC4_TO_INT("SET4") );	break;
	case cSetPreset5:	StoreConfigState( MCC4_TO_INT("SET5") );	break;
	case cSetPreset6:	StoreConfigState( MCC4_TO_INT("SET6") );	break;
	case cSetPreset7:	StoreConfigState( MCC4_TO_INT("SET7") );	break;
	case cSetPreset8:	StoreConfigState( MCC4_TO_INT("SET8") );	break;
	case cSetPreset9:	StoreConfigState( MCC4_TO_INT("SET9") );	break;

	case cPreset0:	handled = RestoreConfigState( MCC4_TO_INT("SET0") );	break;
	case cPreset1:	handled = RestoreConfigState( MCC4_TO_INT("SET1") );	break;
	case cPreset2:	handled = RestoreConfigState( MCC4_TO_INT("SET2") );	break;
	case cPreset3:	handled = RestoreConfigState( MCC4_TO_INT("SET3") );	break;
	case cPreset4:	handled = RestoreConfigState( MCC4_TO_INT("SET4") );	break;
	case cPreset5:	handled = RestoreConfigState( MCC4_TO_INT("SET5") );	break;
	case cPreset6:	handled = RestoreConfigState( MCC4_TO_INT("SET6") );	break;
	case cPreset7:	handled = RestoreConfigState( MCC4_TO_INT("SET7") );	break;
	case cPreset8:	handled = RestoreConfigState( MCC4_TO_INT("SET8") );	break;
	case cPreset9:	handled = RestoreConfigState( MCC4_TO_INT("SET9") );	break;

	default:
		handled = false;
	}

	return handled;
}

void GForce::StoreConfigState( long inParamName )
{
	UtilStr str;

	str.Assign( mWaveShapeName );
	str.Append( ',' );
	str.Append( mColorMapName );
	str.Append( ',' );
	str.Append( mField -> GetName() );
	str.Append( ',' );

	mPrefs.SetPref( inParamName, str );
	Println( "State stored." );
}

bool GForce::RestoreConfigState( long inParamName )
{
	UtilStr str, configName;
//	long pos, n;
	bool found = false;
/*
	if ( mPrefs.GetPref( inParamName, str ) ) {

		// Parse the waveshape config name
		pos = str.FindNextInstanceOf( 0, ',' );
		configName.Assign( str.getCStr(), pos - 1 );
		n = mWaveShapes.FetchBestMatch( configName );
		loadWaveShape( n, false );
		mShapeSlideShow = false;

		// Parse the colormap config name
		str.Trunc( pos, false );
		pos = str.FindNextInstanceOf( 0, ',' );
		configName.Assign( str.getCStr(), pos - 1 );
		n = mColorMaps.FetchBestMatch( configName );
		loadColorMap( n, false );
		mColorSlideShow = false;

		// Parse the colormap config name
		str.Trunc( pos, false );
		n = mDeltaFields.FetchBestMatch( str );
		loadDeltaField( n );
		mFieldSlideShow = false;

		found = true;
	}
*/
	return found;
}

void GForce::ManageColorChanges()
{
	int i;

	// If in a ColorMap transition/morph
	if ( mColorTransTime > 0 ) {

		// If we've the ColorMap transition is over, end it
		if ( mT_MS > mColorTransEnd ) {
			GF_Palette* temp = mGF_Palette;
			mGF_Palette = mNextPal;
			mNextPal = temp;
			mColorTransTime = -1;
			mNextColorChange = mT + mColorInterval.Evaluate();
		} }

	// Time for a color map change?
	else if ( mT > mNextColorChange && mColorSlideShow ) {

		// Load the next config in the (randomized) config list...
		i = mColorPlayList.FindIndexOf( mCurColorMapNum );

		// Make a new play list if we've reached the end of the list...
		if ( i >= mColorPlayList.Count() ) {
			mColorPlayList.Randomize();
			i = 0;
		}
		loadColorMap( mColorPlayList.Fetch( i + 1 ), true );
	}

	// Update the screen palette if it's time
	if ( mT > mNextPaletteUpdate ) {

		// If in a ColorMap transition/morph then we must set mColorTrans, for it's linked into mGF_Palette
		if ( mColorTransTime > 0 ) {
			float t = (float) ( mColorTransEnd - mT_MS ) / ( (float) mColorTransTime );
			mColorTrans = pow( t, TRANSITION_ALPHA );
		}

		// Evaluate the palette at this time
		mGF_Palette -> Evaluate( mPalette );

		// Set our offscreen ports to the right palette...
		mPort.SetPalette( mPalette );

		// If we're at fullsceen, the screen device may need the current palette too
/*		if ( mAtFullScreen && mFullscreenDepth == 8 ) {
//			mScreen.SetPalette( mPalette );
			mPortA.PreventActivate( mOutPort );
			mPortB.PreventActivate( mOutPort );
		}
*/
		// Reevaluate the palette a short time from now
		mNextPaletteUpdate = mT + .1;
	}
}

void GForce::ManageShapeChanges()
{
	int i;

	// If in a WaveShape transition/morph
	if ( mShapeTransTime > 0 ) {

		// If we've the ColorMap transition is over, end it
		if ( mT_MS > mShapeTransEnd ) {
			GF_WaveShape* temp = mWave;
			mWave = mNextWave;
			mNextWave = temp;
			mShapeTransTime = -1;
			mNextShapeChange = mT + mShapeInterval.Evaluate();
		}
	}

	// Time for a wave shape change?
	else if ( mT > mNextShapeChange && mShapeSlideShow ) {

		// Load the next config in the (randomized) config list...
		i = mShapePlayList.FindIndexOf( mCurShapeNum );

		// Make a new play list if we've reached the end of the list...
		if ( i >= mShapePlayList.Count() ) {
			mShapePlayList.Randomize();
			i = 0;
		}
		loadWaveShape( mShapePlayList.Fetch( i + 1 ), true );
	}

}

void GForce::ManageFieldChanges()
{
	long i;

	// If we have have a delta field in mid-calculation, chip away at it...
	if ( ! mNextField -> IsCalculated() )
		mNextField -> CalcSome();

	if ( mT > mNextFieldChange && mNextField -> IsCalculated() && mFieldSlideShow ) {

		// Load the next field in the (randomized) field list...
		i = mFieldPlayList.FindIndexOf( mCurFieldNum );

		// Make a new play list if we've reached the end of the list...
		if ( i >= mFieldPlayList.Count() ) {
			mFieldPlayList.Randomize();
			i = 0;
		}

		// loadGradField() will initiate computation on mField with a new grad field...
		loadDeltaField( mFieldPlayList.Fetch( i + 1 ) );
		DeltaField* temp = mField;
		mField = mNextField;
		mNextField = temp;

		// If the pref says so, display that we're loading a new config
		if ( mNewConfigNotify ) {
			Print( "Loaded DeltaField: " );
			Println( mField -> GetName() );
		}
	}
}

void GForce::ManageParticleChanges()
{
	float rndVar;

	if ( mT > mNextParticleCheck && mParticlesOn ) {

		// Generate a random probability value.
		rndVar = ( (float) rand() ) / ( (float) RAND_MAX );

		// Comparing that to the evalated probability of a new particle being spawned determines if a new one *should* be spawned
		if ( rndVar < mParticleProbabilityFcn.Evaluate() ) {

			SpawnNewParticle();
		}

		// Check to make a new particle one second from now
		mNextParticleCheck = mT + 1;
	}
}

void GForce::DrawParticles( PixPort& inPort )
{
	// Draw all the particles
	ParticleGroup* particle, *next;
	particle = (ParticleGroup*) mRunningParticlePool.GetHead();
	while ( particle ) {
		next = (ParticleGroup*) particle -> GetNext();

		// When particles stop, move them to a holding/stopped list
		if ( ! particle -> IsExpired() )
			particle -> DrawGroup( inPort );
		else {
			mStoppedParticlePool.addToHead( particle );

			// Update the var that holds how many particles are running (and is accessible in the PPrb expr)
			mNumRunningParticles = mRunningParticlePool.shallowCount();
		}

		particle = next;
	}

}

// A linear spread is the default field
#define __FIELD_FACTORY		"\
	Aspc=0,\
	srcX=\"x * .9\",\
	srcY=\"y * .9\",\
	Vers=100\
	"
// A centered circle is the default shape
#define __SHAPE_FACTORY		"\
	Stps=-1,\
	B0=\"t * 0.0003\",\
	Aspc=1,\
	C0=\"abs( mag( s ) ) * 0.15 + .3\",\
	C1=\"s * 6.28318530 + b0\",\
	X0=\"c0 * cos( c1 )\",\
	Y0=\"c0 * sin( c1 )\",\
	Vers=100\
	"
// A single color is the defaut color
#define __COLOR_FACTORY		"\
	H=\".9\",\
	S=\".8\",\
	V=\"i\",\
	Vers=100\
	"

bool GForce::loadSpecs(char *type, long &specNum,
	char *defaults, ArgList &args, FileSysIDList &specList,
	UtilStr &mapName)
{
	long flags;
	FileObj itemID;
	XLongList catalog;
 	const UtilStr *name;

	// Fetch the spec for our config file or folder
	itemID = specList.FetchID( specNum );
	flags = mMainFolder.GetInfo( itemID, MCC4_TO_INT("flag") );
	name = specList.Fetch( specNum );

	if ( mNewConfigNotify ) {
		Print( "Loaded: " );
		Print( type );
		Print( ": " );
		if ( name ) { Println( name ); }
		else { Println( "<Factory Default>" ); }
	}

	if ( flags && name ) {
		if ( flags & FILE_SYS_FOLDER )
			mMainFolder.Catalog( itemID, catalog );
		else if ( flags & FILE_SYS_DATA )
			catalog.Add( itemID );

		// Load each config...
		itemID = catalog.Fetch( 1 );
		args.SetArgs( mMainFolder.Read( itemID ) );
		printf("Test me %li\n", args.NumArgs());

		mapName.Assign( name );
	}
	else if (defaults != NULL) {
		args.SetArgs( defaults );
		printf("Default %s\n", type);
		mapName.Assign( "<Factory Default>" );
	}

	return ( flags && name );
}

void GForce::loadColorMap( long inColorMapNum, bool inAllowMorph )
{
	ArgList args;

	loadSpecs("ColorMap", inColorMapNum, __COLOR_FACTORY,
		args, mColorMaps, mColorMapName);
	mCurColorMapNum = inColorMapNum;

	// If first time load, don't do any transition/morph, otherwise set up the morph
	if ( mGF_Palette == NULL || ! inAllowMorph ) {
		mGF_Palette = &mPal1;
		mNextPal	= &mPal2;
		mGF_Palette -> Assign( args );
		mColorTransTime = -1;
		mNextColorChange = mT + mColorInterval.Evaluate(); }
	else {
		mNextPal -> Assign( args );
		mGF_Palette -> SetupTransition( mNextPal, &mColorTrans );

		// Calculate how long this transition/morph will be
		mColorTransTime	= EgOSUtils::Rnd( mTransitionLo * 1000, mTransitionHi * 1000 );
		mColorTransEnd	= mT_MS + mColorTransTime;
	}
}

void GForce::loadDeltaField( long inFieldNum )
{
	ArgList args;
	UtilStr	fieldName;

	loadSpecs("DeltaField", inFieldNum,
		__FIELD_FACTORY, args, mDeltaFields, fieldName);
	mCurFieldNum = inFieldNum;

	// Initiate recomputation of mField
	mField -> Assign( args, fieldName );
	mNextFieldChange = mT + mFieldInterval.Evaluate();
}

void GForce::loadWaveShape( long inShapeNum, bool inAllowMorph )
{
	ArgList	args;

	loadSpecs("WaveShape", inShapeNum, __SHAPE_FACTORY,
		args, mWaveShapes, mWaveShapeName);
	mCurShapeNum = inShapeNum;

	// If first time load, don't do any transition/morph, otherwise set up the morph
	if ( mWave == NULL || ! inAllowMorph ) {
		mWave		= &mWave1;
		mNextWave	= &mWave2;
		mWave -> Load( args, mNum_S_Steps );
		mNextShapeChange = mT + mShapeInterval.Evaluate();
		mShapeTransTime = -1; }
	else {
		mNextWave -> Load( args, mNum_S_Steps );
		mWave -> SetupTransition( mNextWave );

		// Calculate how long this transition/morph will take
		mShapeTransTime	= EgOSUtils::Rnd( mTransitionLo * 1000, mTransitionHi * 1000 );
		mShapeTransEnd	= mT_MS + mShapeTransTime;
	}
}

void GForce::loadParticle( long inParticleNum )
{
	ArgList args;
	ParticleGroup* newParticle;
	UtilStr particleName;
	bool loaded;

	loaded = loadSpecs("Particle", inParticleNum,
		NULL, args, mParticles, particleName);
	mCurParticleNum = inParticleNum;

	if (loaded) {
		// Avoid having to reallocate mem...
		newParticle = (ParticleGroup*) mStoppedParticlePool.GetHead();

		// If there weren'y any particles already expired, make a new instance
		if ( ! newParticle )
			newParticle = new ParticleGroup( &mT, (ExprUserFcn**) &mSampleFcn );

		// Add the new particle to the group that gets executed each frame
		newParticle -> mTitle.Assign( particleName );
		mRunningParticlePool.addToHead( newParticle );

		// The GF particle probability fcn has access to these variables
		mNumRunningParticles = mRunningParticlePool.shallowCount();
		mLastParticleStart = mT;

		// Determine how long this particle will be around
		newParticle -> SetDuration( mParticleDurationFcn.Evaluate() );

		// Tell the particle to compile it's config text
		newParticle -> Load( args );
	}
}
/*
void GForce::NewSong()
{
	mTrackText.Assign( mTrackMetaText );
	mTrackText.Replace( "\\r", "\r" );
	mTrackText.Replace( "#ARTIST#", mArtist.getCStr(), false );
	mTrackText.Replace( "#ALBUM#", mAlbum.getCStr(), false );
	mTrackText.Replace( "#TITLE#", mSongTitle.getCStr(), false );

	CalcTrackTextPos();

	mLastSongStart = mT;
}
*/

void GForce::SpawnNewParticle()
{
	int i;

	// Load the next particle in the (randomized) play list...
	i = mParticlePlayList.FindIndexOf( mCurParticleNum );

	// Make a new play list if we've reached the end of the list...
	if ( i >= mParticlePlayList.Count() ) {
		mParticlePlayList.Randomize();
		i = 0;
	}

	// loadGradField() will initiate computation on mField with a new grad field...
	loadParticle( mParticlePlayList.Fetch( i + 1 ) );
}
/*
SDL_Color GForce::GetPaletteColor(const int index)
{
	SDL_Color result = { 0 };
	result.r = mPalette[index].red;
	result.g = mPalette[index].green;
	result.b = mPalette[index].blue;
	return result;
}
*/
void GForce::MakeStateCmdLine( UtilStr& outCmdList ) {

	// Turn the all the running config into a command line
//	outCmdList.Assign( mCurConfigName );
}

void GForce::DoFrame() {

	Rect dirtyRect;

	// We're about to draw, so record some sound
	RecordSample( true, false );

	ManageColorChanges();
	ManageShapeChanges();
	ManageFieldChanges();
	ManageParticleChanges();

	// Prepare to tell DrawFrame() what's dirty
	dirtyRect.top = dirtyRect.left = 32000;
	dirtyRect.bottom = dirtyRect.right = -32000;
/*
	if ( mCurPort == &mPortA )
		mPortB.Fade( mPortA, mField -> GetField() );
	else
		mPortA.Fade( mPortB, mField -> GetField() );
*/
	// Draw all the current particles
	DrawParticles( mPort );

	// Draw the current wave shape for the current music sample playing
	// If there's a morph going, drawing is a mix of both waves
	if ( mShapeTransTime > 0 ) {
		float morphPct = (float) ( mShapeTransEnd - mT_MS ) / ( (float) mShapeTransTime );
		mWave -> Draw( mNum_S_Steps, mPort, 1, mNextWave, morphPct ); }
	else
		mWave -> Draw( mNum_S_Steps, mPort, 1, NULL, 0 );

	// Draw any track text that's active...
	ManageTrackText();

	// Draw the console (if its being drawn)
	if ( mConsoleLines.Count() > 0 ) {

//		mPort.SetTextColor( *mWorld[ 0 ] -> GetForeColor() );

		// Draw the console to the offscreen port and know the rect needs updating
		DrawConsole( &mPort );
		if ( IsValidRect( mConsoleDirtyRgn ) )
			::UnionRect( &dirtyRect, &mConsoleDirtyRgn, &dirtyRect );

		mVideoOutput -> AcceptFrame( mPort, &dirtyRect, mT_MS ); }
	else
		mVideoOutput -> AcceptFrame( mPort, &dirtyRect, mT_MS );
}

void GForce::ManageTrackText() {

	RGBColor textColor = { 255, 255, 255 };
	float i, t;

	// Is there any track text active?
	if ( mTrackText.length() > 0 ) {

		// Have the text fade in, then fade out...
		t = 1.0 - ( mTrackTextEndT - mT ) / ( (float) mTrackTextDur );
		i = 1.6 * sin( PI * t );

		if ( mT <= mTrackTextEndT ) {

			// Calc and set the port text color then draw it
//			mWorld[ 0 ] -> CalcForeground( i, textColor );
			mPort.SetTextColor( textColor );

			mPort.SetClipRect();
			mPort.DrawText( mTrackTextRect.left, mTrackTextRect.top, mTrackText );

			// We need to redraw that area in the next frame
			RefreshRect( &mTrackTextRect ); }

		// Signal no more track text if it's expired
		else
			mTrackText.Wipe();
	}

}

void GForce::SetPrefsFactory() {

	static GForce::FactoryPrefPresets presets = {

		PREFS_COMPAT_VERSION,

		FACTORY_FFT_BIN_START,
		FACTORY_FFT_STEPS_PER_BIN,
		FACTORY_FFT_SMOOTH,
		FACTORY_FFT_NUM_BINS,
		FACTORY_FFT_FADEAWAY,
		FACTORY_FFT_TRANSFORM,

		FACTORY_DEPTH,
		{
			FACTORY_MAX_X,
			FACTORY_MAX_Y
		},
		FACTORY_SAMPLE_SMOOTH,
		FACTORY_SAMPLE_NUMBINS,
		FACTORY_FPS,
		FACTORY_FPS
	};

	PluginGlue::SetPrefsFactory(presets);

	mKeyMap.Assign( "THRU~OGF,.\\[]{}L()<>M`" );
}

void GForce::PortResized( long inX, long inY ) {

	long depth;

	if ( mVideoOutput -> GetDepth() == 16 )
		depth = 16;
	else
		depth = 32;
	mPort.Init( inX, inY, depth );

	// Use the font and size in the prefs...
	mPort.SetDefaultFont( mTextFont, mTextSize );
}

void GForce::TimeIndexHasChanged( long ) {

	// Chuck all the samples we had
//	for ( int i = 0; i < mNumWorlds; i++ )
//		mWorld[ i ] -> ExpireSamples();

	// Reinit the config to be safe
//	LoadConfig( mCurConfigNum, WC_NO_MORPH );
}

void GForce::StartTrackText() {

	long x, y;

	mTrackText.Wipe();

	if ( mArtist.length() > 0 ) {
		mTrackText.Append( mArtist );
		mTrackText.Append( '\r' );
	}

	if ( mSongTitle.length() > 0 ) {
		mTrackText.Append( mSongTitle );
		mTrackText.Append( '\r' );
	}

	if ( mAlbum.length() > 0 ) {
		mTrackText.Append( mAlbum );
		mTrackText.Append( '\r' );
	}

	if ( mTrackText.getChar( mTrackText.length() ) == '\r' )
		mTrackText.Trunc( 1 );

	if ( mTrackText.length() > 0 ) {
		mPort.SetDefaultFont();
		mPort.TextRect( mTrackText.getCStr(), x, y );

		// Will the track text fit?  If so, put it in the bottom left corner
		if ( y < mPort.GetY() && mTrackTextDur > 0 ) {
			mTrackTextRect.left	= 7;
			mTrackTextRect.top 	= mPort.GetY() - y;
			mTrackTextRect.right 	= mTrackTextRect.left + x;
			mTrackTextRect.bottom 	= mTrackTextRect.top  + y;

			mTrackTextEndT = mT + mTrackTextDur; }

		// If mTrackDesc is empty, that means no track tect is active
		else
			mTrackText.Wipe();
	}
}
