
#ifndef __WINDOW_DEVICE_H__
#define __WINDOW_DEVICE_H__

#include "DC_VideoDevice.h"

// ### If Mac, in your global header, define USE_DRAW_SPROCKETS 1 or USE_DISP_MGR 1 if you want full screeen ability!!!
// ### If Win, in your global header, define USE_DIRECTX 1 if you want full screeen ability!!!

#include "Eg Common.h"

#if EG_WIN

typedef RGBQUAD PixPalEntry;

#if USE_DIRECTX
#include <ddraw.h>
#else
typedef long LPDIRECTDRAW;
typedef long LPDIRECTDRAWSURFACE;
typedef long LPDIRECTDRAWPALETTE;
#endif
#endif

#if EG_MAC
#include <QuickDraw.h>
#include <QDOffscreen.h>
#include <LowMem.h>

typedef ColorSpec PixPalEntry;


#if USE_DISP_MGR
	#undef USE_DRAW_SPROCKETS
	#include "RequestVideo.h"
#elif USE_DRAW_SPROCKETS
	#include <DrawSprocket.h>
#else
	typedef long DSpContextReference;
	struct DSpContextAttributes	{ };
#endif
#else
#endif



class WindowDevice : public DC_VideoDevice {

public:
	WindowDevice();
	virtual	~WindowDevice();

	void			SetOSWindow( PP_WindowPtr inWind, PP_WindowPtr inParentWind );

	// Returns the display ID that contains the centerpoint of this window
	long			GetParentDisplayID();

	// Use these fcns to enter & exit fullscreen mode.  ioSize contains the desired screen resolution
	// on entry and contains the final fullscreen res dimentions upon return.  If either h or v is 0, the sys default is used.
	// inWin expands to fit fullscreen size if in Windows *or* we're no using mac drawsprockets
	// If Mac and using draw sprockets: inFreq is the preferred freq (or use 0 for default freq)
	bool			EnterFullscreen( long inDispID, Point& ioSize, int inBitDepth );
	void			ExitFullscreen();

	PP_WindowPtr		GetWindow()											{ return mWind;			}

	virtual void		Erase( bool inUpdateNow );

	virtual void		Resize( Rect& inRect );

	void			GetWindowRect( Rect& outRect );

protected:
	virtual void		BeginFrame_Self();
	virtual void		EndFrame_Self();
	virtual void		PreFrame_Self( PixPort* inSrceFrame );

	PP_WindowPtr		mWind;
	PP_WindowPtr		mParentWind;
	bool			mBorderlessWind;

	long			mDispID;

	Rect			mWindRectHolder;

#if EG_WIN
	LPDIRECTDRAWPALETTE FAR	mFS_Palette;
	LPDIRECTDRAWSURFACE	mContextRef;
	LPDIRECTDRAW		mDDObj;
#elif EG_MAC
#if USE_DRAW_SPROCKETS
	DSpContextReference	mContextRef;
	DSpContextAttributes	mContext;
#elif USE_DISP_MGR
	GrafPtr			mContextRef;
	RgnHandle		mMenuBarRgn;
	long			mMenuBarHeight;
#else
	long			mContextRef;
#endif // USE_DISP_MGR
#elif EG_SDL
	// Otherwise we just provide a untyped pointer
	void*			mContextRef;
#endif

};

#endif // __WINDOW_DEVICE_H__
