#ifndef _PrefPackage_H
#define _PrefPackage_H


class PrefPackageClient;

/* To make your own PrefPackage, derive from this class and define Init() and ShitDown() */


class PrefPackage {

	public:
		/*   
		Contructor for an instance of PrefPackage.
		Pre:  Init() is called immediately after.  */
									PrefPackage()			{ }
		virtual 					~PrefPackage()			{ }
		
		/*
		Inits this PrefPackage.
		Pre: <inCaller> identifies who is using this PrefPackage.  */
		virtual void				Init( PrefPackageClient* inCaller ) = 0;
		
		
		/*  
		Initiates the a shutsdown of this instance of a pref window immediately.  A PrefPackage can be ended
		one of two ways: either this instance of the PrefPackage calls PrefWindowGone() or the Client calls 
		Shutdown() on this instance (where this PrefPackage is expected to call PrefWindowGone()) 
		Post: As soon as this instance is shutdown, PrefWindowGone() must be called to
		tell the calling PrefPackageClient that it can delete this instance of the PrefPackage. */  
		virtual void				Shutdown() = 0;

};


#endif