
#ifndef __PLUGIN_GLUE_DEF_H__
#define __PLUGIN_GLUE_DEF_H__

#include "Eg Common.h"

#if STANDALONE
#include "SoundInputPort.h"
#include "VideoExporter.h"
#endif

#if ITUNES
#include "iTunesVisualAPI.h"
#endif

#if ITUNES
#define FACTORY_FFT_BIN_START			4
#define FACTORY_FFT_STEPS_PER_BIN		2
#define SAMPLE_SCALE					.0039
#define FACTORY_FFT_TRANSFORM			".4 * log( .0037 * x * ( 3.1 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	unsigned char* 		mSpectrum_L;
	unsigned char* 		mSpectrum_R;
	unsigned char* 		mWaveform;
};

typedef struct VisualPluginData {
	void *			appCookie;
	ITAppProcPtr		appProc;

	ITFileSpec		pluginFileSpec;

	bool			mPlayingMusic;
	bool			mIsVisible;
	SPluginData		mPlugData;
	int			mSkippedFrames;
	PluginGlue*		mPlugin;
	DC_VideoDevice*		mPluginOutput;
	CGrafPtr		mPort;
	Handle			mKCHRHandle;
	unsigned long		mKCHRID;
	unsigned long		mKeyState;
	ITTrackInfo		mTrackInfo;
	ITStreamInfo		mStreamInfo;

} VisualPluginData;
#endif


#if SOUNDJAM || AUDION
#define FACTORY_FFT_BIN_START			4
#define FACTORY_FFT_STEPS_PER_BIN		2
#define SAMPLE_SCALE					.0039
#define FACTORY_FFT_TRANSFORM			".36 * log( .0037 * x * ( 3.1 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	unsigned char* 	mSpectrum_L;
	unsigned char* 	mSpectrum_R;
	unsigned char* 	mWaveform;
};
#endif


#if GFORCE_PRO && EG_MAC
#define FACTORY_FFT_BIN_START			4
#define FACTORY_FFT_STEPS_PER_BIN		4
#define SAMPLE_SCALE					.000021
#define FACTORY_FFT_TRANSFORM			".8 * log( .005 * x + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
};
#endif



#if STANDALONE && EG_MAC
#define FACTORY_FFT_BIN_START			4
#define FACTORY_FFT_STEPS_PER_BIN		4
#define SAMPLE_SCALE					.000021
#define FACTORY_FFT_TRANSFORM			".8 * log( .005 * x + 1 )"
struct SPluginData {
};
#endif

#if STANDALONE && EG_WIN
#define FACTORY_FFT_BIN_START			12
#define FACTORY_FFT_STEPS_PER_BIN		15
#define SAMPLE_SCALE					.000029
#define FACTORY_FFT_TRANSFORM			"log( .003 * x + 1 )"
struct SPluginData {
};
#endif

#if WINAMP
#define FACTORY_FFT_BIN_START			14
#define FACTORY_FFT_STEPS_PER_BIN		2
#define SAMPLE_SCALE					.0043
#define FACTORY_FFT_TRANSFORM			"1.1 * log( .008 * x * ( 1.3 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	unsigned char* 	mSpectrum_L;
	unsigned char* 	mSpectrum_R;
 	char*			mWaveform;
};
#endif


#if ENTHEOGEN
#define FACTORY_FFT_BIN_START			1
#define FACTORY_FFT_STEPS_PER_BIN		1
#define SAMPLE_SCALE					.0005
#define FACTORY_FFT_TRANSFORM			"90 * log( .0004 * x * ( .25 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	float* 			mSpectrum;
 	float*			mWaveform;
};
#endif

#if SONIQUE
#define FACTORY_FFT_BIN_START			32
#define FACTORY_FFT_STEPS_PER_BIN		2
#define SAMPLE_SCALE					.006
#define FACTORY_FFT_TRANSFORM			"3.5 * log( .008 * x * ( .4 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	unsigned char* 		mSpectrum_L;
	unsigned char* 		mSpectrum_R;
 	char*			mWaveform;
};
#endif


#if UNSANITY_ECHO
#define FACTORY_FFT_BIN_START			1
#define FACTORY_FFT_STEPS_PER_BIN		1
#define SAMPLE_SCALE					.00002
#define FACTORY_FFT_TRANSFORM			".17 * log( .01 * x * ( .25 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	bool			mPlayingMusic;
	double*			mSpectrum;
 	short int*		mWaveform;
};
#endif

#if XMMS
#define FACTORY_FFT_BIN_START			32
#define FACTORY_FFT_STEPS_PER_BIN		2
#define SAMPLE_SCALE				.00006
#define FACTORY_FFT_TRANSFORM			"2.5 * log( .002 * x * ( .4 + w ) + 1 )"
struct SPluginData {
	long			mSample_NumBins;
	long 			mFFT_NumBins;
	short int* 		mSpectrum_L;
	short int* 		mSpectrum_R;
 	short int*		mWaveform_L;
	short int*		mWaveform_R;
};
#endif

#define c55_CaptureType			MCC4_TO_INT( "55_C" )

#endif // __PLUGIN_GLUE_DEF_H__
