
#ifndef __LOGICAL_GRAPHIC_H__
#define __LOGICAL_GRAPHIC_H__

#include "LogicalDrawingDevice.h"

/* Examples of LogicalGraphical objects are things that define visual object by exact/infinite
means.  Examples:
  - A fractal given by its equation
  - the plot of the fcn y = sin( x )
  - A blue sphere with radius r

Bitmap graphics are a not LogicalGraphical objects because although they are exactly defined by a sequence
of integer values, it's not possible to know how the bitmap was generated (ex, bitmap image of a fractal). In
other words, you can always go from a LogicalGraphical to a bitmap but you can go from a bitmap to a
LogicalGraphical (other than to transformed bitmap).
*/

class LogicalGraphic {

public:
	// Generates a sequence of drawing commands that draws this object on the given device.
	// Although the draw commands are device independent, the appearance/commands issued may
	// depend on the device settings (ex, as the device has a higher scale, the object
	// draws more detail).
	virtual void		Regen( LogicalDrawingDevice* inOutput, DrawCmdList& outCmds ) = 0;

	bool			IsTimeDependent()						{ return mIsTimeDependent;		}

protected:
	bool			mIsTimeDependent;
};


/*
	// The logical drawing commands (ie, drawing commands to a logical/perfect device--ex, PDF)
		// that represent this object
		LogicalPath				mPath;
*/

#endif // __LOGICAL_GRAPHIC_H__
