/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_OPENGL_STATUS_H__
#define __DISPLAYER_OPENGL_STATUS_H__

#include <gtk/gtkwidget.h>

#include "singit/song.h"
#include "singit/config_gen.h"
#include "singit/framerate_counter.h"
#include "singit/singleton.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_OPENGL_STATUS            (opengl_status_get_type ())
#define OPENGL_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_OPENGL_STATUS, OpenGLStatus))
#define OPENGL_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_OPENGL_STATUS, OpenGLStatus))
#define IS_OPENGL_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_OPENGL_STATUS))
#define IS_OPENGL_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_OPENGL_STATUS))

typedef struct _OpenGLStatus       OpenGLStatus;
typedef struct _OpenGLStatusClass  OpenGLStatusClass;

struct _OpenGLStatus
{
	SingitSingleton       singleton;

	SingitConfigGen      *config;

	SingitSong           *song;
	GList                *next_lyric_line;

	GtkWidget *gl_area_widget;

	gint hide_mouse_id;
	gint jump_to_song;
	guint time;

	gint stereo_bass[2][2];

	gboolean rotate;

	guint display_list;

	gboolean beat;
	gfloat level[3];

	SingitFramerateCounter *sfc;
};

struct _OpenGLStatusClass {

	SingitSingletonClass  parent_class;
};

GtkType            opengl_status_get_type(void);

SingitSingleton*   opengl_status_ref(void);
void               opengl_status_unref(SingitSingleton** single);

SingitSingleton*   opengl_status_noref(void);

#define STATUS \
	OPENGL_STATUS(opengl_status_noref())

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif // __DISPLAYER_OPENGL_STATUS_H__
