/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SOCKET_H__
#define __SOCKET_H__

#include <glib.h>

#include "protocol.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

gboolean singit_socket_setup(void);
void     singit_socket_cleanup(void);
void     singit_socket_start(void);
gint     singit_socket_get_session_id(void);

void singit_socket_packet_write(PacketNode *pkt, gpointer data, gint length);
void singit_socket_packet_ack(PacketNode * pkt);

gint singit_socket_connect_to_session(gint session);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __SOCKET_H__
