/*
	**
	** summary-structures.h
	**
	** Data structures used to store packet summary information
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: summary-structures.h,v 1.2 1999/02/04 10:22:42 dmiller Exp $
	**
 */

#ifndef _SUMMARY_STRUCTURES_H
#define _SUMMARY_STRUCTURES_H

#include <time.h>
#include <sys/types.h>
#include <glib.h>

typedef struct
{
	u_int64_t		key;
	struct HOST		*host1;
	struct HOST		*host2;
	u_int64_t		bytes_sent_1_to_2;
	u_int64_t		bytes_sent_2_to_1;
	u_int64_t		packets_sent_1_to_2;
	u_int64_t		packets_sent_2_to_1;
	u_int64_t		connections_sent_1_to_2;
	u_int64_t		connections_sent_2_to_1;
	time_t			first_seen;
	time_t			last_seen;
} peer_t;

typedef struct HOST
{
	u_int32_t		ip_addr;
	char				*hostname;
	u_int64_t		bytes_sent;
	u_int64_t		bytes_received;
	u_int64_t		packets_sent;
	u_int64_t		packets_received;
	u_int64_t		connections_sent;
	u_int64_t		connections_received;
	time_t			first_seen;
	time_t			last_seen;
	u_int64_t		*peer_keys;
	unsigned long	n_peers;
} host_t;

typedef struct
{
	u_int64_t		total_bytes;
	u_int64_t		total_packets;
	u_int64_t		total_connections;
	time_t			summary_start;
	time_t			summary_finish;
	u_int32_t		active_hosts;
	GHashTable		*hosts;
	GHashTable		*peers;
} summary_t;

#endif /* _SUMMARY_STRUCTURES_H */
