/*
	**
	** packet-parse.h
	**
	** Routines to extract data from network packets
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: packet-parse.h,v 1.3 1999/03/27 00:12:50 dmiller Exp $
	**
 */

#ifndef _PACKET_PARSE_H
#define _PACKET_PARSE_H

#include <sys/types.h>

typedef struct 
{
	int			datalink_type;
	u_int8_t		src_hw_addr[6];
	u_int8_t		dst_hw_addr[6];
	u_int32_t	src_ip_addr;
	u_int32_t	dst_ip_addr;
	u_int16_t	ip_protocol;
	u_int32_t	src_port;
	u_int32_t	dst_port;
	u_int16_t	total_length;
	u_int16_t	header_length;
	int			is_fragment;
	int			is_connection_request;
	time_t		received_time;
} packet_info_t;

/* Parse a packet, filling structure pinfo */
/* Returns 1 on success, 0 on error */
int parse_packet(int link_type, const unsigned char *pkt, 
                 unsigned int len, packet_info_t *pinfo);

/* Returns a string describing the last error to occur */
/* The error string is cleared at each call to parse_packet() */
const char *parse_error(void);

#endif
